// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type AssociateMemberAccountInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that you want to associate with Amazon Macie Classic
	// as a member account.
	//
	// MemberAccountId is a required field
	MemberAccountId *string `locationName:"memberAccountId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateMemberAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateMemberAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateMemberAccountInput"}

	if s.MemberAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MemberAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateMemberAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateMemberAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateMemberAccount = "AssociateMemberAccount"

// AssociateMemberAccountRequest returns a request value for making API operation for
// Amazon Macie.
//
// Associates a specified AWS account with Amazon Macie Classic as a member
// account.
//
//    // Example sending a request using AssociateMemberAccountRequest.
//    req := client.AssociateMemberAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/AssociateMemberAccount
func (c *Client) AssociateMemberAccountRequest(input *AssociateMemberAccountInput) AssociateMemberAccountRequest {
	op := &aws.Operation{
		Name:       opAssociateMemberAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateMemberAccountInput{}
	}

	req := c.newRequest(op, input, &AssociateMemberAccountOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return AssociateMemberAccountRequest{Request: req, Input: input, Copy: c.AssociateMemberAccountRequest}
}

// AssociateMemberAccountRequest is the request type for the
// AssociateMemberAccount API operation.
type AssociateMemberAccountRequest struct {
	*aws.Request
	Input *AssociateMemberAccountInput
	Copy  func(*AssociateMemberAccountInput) AssociateMemberAccountRequest
}

// Send marshals and sends the AssociateMemberAccount API request.
func (r AssociateMemberAccountRequest) Send(ctx context.Context) (*AssociateMemberAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateMemberAccountResponse{
		AssociateMemberAccountOutput: r.Request.Data.(*AssociateMemberAccountOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateMemberAccountResponse is the response type for the
// AssociateMemberAccount API operation.
type AssociateMemberAccountResponse struct {
	*AssociateMemberAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateMemberAccount request.
func (r *AssociateMemberAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
