// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

// The current status of an account as a delegated administrator of Amazon Macie
// for an AWS organization.
type AdminStatus string

// Enum values for AdminStatus
const (
	AdminStatusEnabled             AdminStatus = "ENABLED"
	AdminStatusDisablingInProgress AdminStatus = "DISABLING_IN_PROGRESS"
)

func (enum AdminStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AdminStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The type of currency that data for a usage metric is reported in. Possible
// values are:
type Currency string

// Enum values for Currency
const (
	CurrencyUsd Currency = "USD"
)

func (enum Currency) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Currency) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type DayOfWeek string

// Enum values for DayOfWeek
const (
	DayOfWeekSunday    DayOfWeek = "SUNDAY"
	DayOfWeekMonday    DayOfWeek = "MONDAY"
	DayOfWeekTuesday   DayOfWeek = "TUESDAY"
	DayOfWeekWednesday DayOfWeek = "WEDNESDAY"
	DayOfWeekThursday  DayOfWeek = "THURSDAY"
	DayOfWeekFriday    DayOfWeek = "FRIDAY"
	DayOfWeekSaturday  DayOfWeek = "SATURDAY"
)

func (enum DayOfWeek) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DayOfWeek) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type EffectivePermission string

// Enum values for EffectivePermission
const (
	EffectivePermissionPublic    EffectivePermission = "PUBLIC"
	EffectivePermissionNotPublic EffectivePermission = "NOT_PUBLIC"
)

func (enum EffectivePermission) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum EffectivePermission) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The type of server-side encryption that's used to encrypt objects in the
// S3 bucket. Valid values are:
type EncryptionType string

// Enum values for EncryptionType
const (
	EncryptionTypeNone    EncryptionType = "NONE"
	EncryptionTypeAes256  EncryptionType = "AES256"
	EncryptionTypeAwsKms  EncryptionType = "aws:kms"
	EncryptionTypeUnknown EncryptionType = "UNKNOWN"
)

func (enum EncryptionType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum EncryptionType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The source of an error, issue, or delay. Possible values are:
type ErrorCode string

// Enum values for ErrorCode
const (
	ErrorCodeClientError   ErrorCode = "ClientError"
	ErrorCodeInternalError ErrorCode = "InternalError"
)

func (enum ErrorCode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ErrorCode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The type of action that occurred for the resource and produced the policy
// finding:
type FindingActionType string

// Enum values for FindingActionType
const (
	FindingActionTypeAwsApiCall FindingActionType = "AWS_API_CALL"
)

func (enum FindingActionType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FindingActionType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The category of the finding. Valid values are:
type FindingCategory string

// Enum values for FindingCategory
const (
	FindingCategoryClassification FindingCategory = "CLASSIFICATION"
	FindingCategoryPolicy         FindingCategory = "POLICY"
)

func (enum FindingCategory) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FindingCategory) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The frequency with which Amazon Macie publishes updates to policy findings
// for an account. This includes publishing updates to AWS Security Hub and
// Amazon EventBridge (formerly called Amazon CloudWatch Events). Valid values
// are:
type FindingPublishingFrequency string

// Enum values for FindingPublishingFrequency
const (
	FindingPublishingFrequencyFifteenMinutes FindingPublishingFrequency = "FIFTEEN_MINUTES"
	FindingPublishingFrequencyOneHour        FindingPublishingFrequency = "ONE_HOUR"
	FindingPublishingFrequencySixHours       FindingPublishingFrequency = "SIX_HOURS"
)

func (enum FindingPublishingFrequency) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FindingPublishingFrequency) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The grouping to sort the results by. Valid values are:
type FindingStatisticsSortAttributeName string

// Enum values for FindingStatisticsSortAttributeName
const (
	FindingStatisticsSortAttributeNameGroupKey FindingStatisticsSortAttributeName = "groupKey"
	FindingStatisticsSortAttributeNameCount    FindingStatisticsSortAttributeName = "count"
)

func (enum FindingStatisticsSortAttributeName) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FindingStatisticsSortAttributeName) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The type of finding. Valid values are:
type FindingType string

// Enum values for FindingType
const (
	FindingTypeSensitiveDataS3objectMultiple             FindingType = "SensitiveData:S3Object/Multiple"
	FindingTypeSensitiveDataS3objectFinancial            FindingType = "SensitiveData:S3Object/Financial"
	FindingTypeSensitiveDataS3objectPersonal             FindingType = "SensitiveData:S3Object/Personal"
	FindingTypeSensitiveDataS3objectCredentials          FindingType = "SensitiveData:S3Object/Credentials"
	FindingTypeSensitiveDataS3objectCustomIdentifier     FindingType = "SensitiveData:S3Object/CustomIdentifier"
	FindingTypePolicyIamuserS3bucketPublic               FindingType = "Policy:IAMUser/S3BucketPublic"
	FindingTypePolicyIamuserS3bucketSharedExternally     FindingType = "Policy:IAMUser/S3BucketSharedExternally"
	FindingTypePolicyIamuserS3bucketReplicatedExternally FindingType = "Policy:IAMUser/S3BucketReplicatedExternally"
	FindingTypePolicyIamuserS3bucketEncryptionDisabled   FindingType = "Policy:IAMUser/S3BucketEncryptionDisabled"
	FindingTypePolicyIamuserS3blockPublicAccessDisabled  FindingType = "Policy:IAMUser/S3BlockPublicAccessDisabled"
)

func (enum FindingType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FindingType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The action to perform on findings that meet the filter criteria. To suppress
// (automatically archive) findings that meet the criteria, set this value to
// ARCHIVE. Valid values are:
type FindingsFilterAction string

// Enum values for FindingsFilterAction
const (
	FindingsFilterActionArchive FindingsFilterAction = "ARCHIVE"
	FindingsFilterActionNoop    FindingsFilterAction = "NOOP"
)

func (enum FindingsFilterAction) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FindingsFilterAction) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type GroupBy string

// Enum values for GroupBy
const (
	GroupByResourcesAffectedS3bucketName GroupBy = "resourcesAffected.s3Bucket.name"
	GroupByType                          GroupBy = "type"
	GroupByClassificationDetailsJobId    GroupBy = "classificationDetails.jobId"
	GroupBySeverityDescription           GroupBy = "severity.description"
)

func (enum GroupBy) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum GroupBy) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The operator to use in a condition. Valid values are:
type JobComparator string

// Enum values for JobComparator
const (
	JobComparatorEq       JobComparator = "EQ"
	JobComparatorGt       JobComparator = "GT"
	JobComparatorGte      JobComparator = "GTE"
	JobComparatorLt       JobComparator = "LT"
	JobComparatorLte      JobComparator = "LTE"
	JobComparatorNe       JobComparator = "NE"
	JobComparatorContains JobComparator = "CONTAINS"
)

func (enum JobComparator) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum JobComparator) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The current status of a classification job. Possible values are:
type JobStatus string

// Enum values for JobStatus
const (
	JobStatusRunning   JobStatus = "RUNNING"
	JobStatusPaused    JobStatus = "PAUSED"
	JobStatusCancelled JobStatus = "CANCELLED"
	JobStatusComplete  JobStatus = "COMPLETE"
	JobStatusIdle      JobStatus = "IDLE"
)

func (enum JobStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum JobStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The schedule for running a classification job. Valid values are:
type JobType string

// Enum values for JobType
const (
	JobTypeOneTime   JobType = "ONE_TIME"
	JobTypeScheduled JobType = "SCHEDULED"
)

func (enum JobType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum JobType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The property to use to filter the results. Valid values are:
type ListJobsFilterKey string

// Enum values for ListJobsFilterKey
const (
	ListJobsFilterKeyJobType   ListJobsFilterKey = "jobType"
	ListJobsFilterKeyJobStatus ListJobsFilterKey = "jobStatus"
	ListJobsFilterKeyCreatedAt ListJobsFilterKey = "createdAt"
	ListJobsFilterKeyName      ListJobsFilterKey = "name"
)

func (enum ListJobsFilterKey) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ListJobsFilterKey) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The property to sort the results by. Valid values are:
type ListJobsSortAttributeName string

// Enum values for ListJobsSortAttributeName
const (
	ListJobsSortAttributeNameCreatedAt ListJobsSortAttributeName = "createdAt"
	ListJobsSortAttributeNameJobStatus ListJobsSortAttributeName = "jobStatus"
	ListJobsSortAttributeNameName      ListJobsSortAttributeName = "name"
	ListJobsSortAttributeNameJobType   ListJobsSortAttributeName = "jobType"
)

func (enum ListJobsSortAttributeName) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ListJobsSortAttributeName) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The status of an Amazon Macie account. Valid values are:
type MacieStatus string

// Enum values for MacieStatus
const (
	MacieStatusPaused  MacieStatus = "PAUSED"
	MacieStatusEnabled MacieStatus = "ENABLED"
)

func (enum MacieStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MacieStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type OrderBy string

// Enum values for OrderBy
const (
	OrderByAsc  OrderBy = "ASC"
	OrderByDesc OrderBy = "DESC"
)

func (enum OrderBy) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum OrderBy) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The current status of the relationship between an account and an associated
// Amazon Macie master account (inviter account). Possible values are:
type RelationshipStatus string

// Enum values for RelationshipStatus
const (
	RelationshipStatusEnabled                     RelationshipStatus = "Enabled"
	RelationshipStatusPaused                      RelationshipStatus = "Paused"
	RelationshipStatusInvited                     RelationshipStatus = "Invited"
	RelationshipStatusCreated                     RelationshipStatus = "Created"
	RelationshipStatusRemoved                     RelationshipStatus = "Removed"
	RelationshipStatusResigned                    RelationshipStatus = "Resigned"
	RelationshipStatusEmailVerificationInProgress RelationshipStatus = "EmailVerificationInProgress"
	RelationshipStatusEmailVerificationFailed     RelationshipStatus = "EmailVerificationFailed"
	RelationshipStatusRegionDisabled              RelationshipStatus = "RegionDisabled"
	RelationshipStatusAccountSuspended            RelationshipStatus = "AccountSuspended"
)

func (enum RelationshipStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum RelationshipStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The property to use in a condition that determines which objects are analyzed
// by a classification job. Valid values are:
type ScopeFilterKey string

// Enum values for ScopeFilterKey
const (
	ScopeFilterKeyBucketCreationDate     ScopeFilterKey = "BUCKET_CREATION_DATE"
	ScopeFilterKeyObjectExtension        ScopeFilterKey = "OBJECT_EXTENSION"
	ScopeFilterKeyObjectLastModifiedDate ScopeFilterKey = "OBJECT_LAST_MODIFIED_DATE"
	ScopeFilterKeyObjectSize             ScopeFilterKey = "OBJECT_SIZE"
	ScopeFilterKeyTag                    ScopeFilterKey = "TAG"
)

func (enum ScopeFilterKey) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ScopeFilterKey) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The category of sensitive data that was detected and produced the finding.
// Possible values are:
type SensitiveDataItemCategory string

// Enum values for SensitiveDataItemCategory
const (
	SensitiveDataItemCategoryFinancialInformation SensitiveDataItemCategory = "FINANCIAL_INFORMATION"
	SensitiveDataItemCategoryPersonalInformation  SensitiveDataItemCategory = "PERSONAL_INFORMATION"
	SensitiveDataItemCategoryCredentials          SensitiveDataItemCategory = "CREDENTIALS"
	SensitiveDataItemCategoryCustomIdentifier     SensitiveDataItemCategory = "CUSTOM_IDENTIFIER"
)

func (enum SensitiveDataItemCategory) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum SensitiveDataItemCategory) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The textual representation of the finding's severity. Possible values are:
type SeverityDescription string

// Enum values for SeverityDescription
const (
	SeverityDescriptionLow    SeverityDescription = "Low"
	SeverityDescriptionMedium SeverityDescription = "Medium"
	SeverityDescriptionHigh   SeverityDescription = "High"
)

func (enum SeverityDescription) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum SeverityDescription) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type SharedAccess string

// Enum values for SharedAccess
const (
	SharedAccessExternal  SharedAccess = "EXTERNAL"
	SharedAccessInternal  SharedAccess = "INTERNAL"
	SharedAccessNotShared SharedAccess = "NOT_SHARED"
)

func (enum SharedAccess) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum SharedAccess) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The storage class of the S3 bucket or object. Possible values are:
type StorageClass string

// Enum values for StorageClass
const (
	StorageClassStandard           StorageClass = "STANDARD"
	StorageClassReducedRedundancy  StorageClass = "REDUCED_REDUNDANCY"
	StorageClassStandardIa         StorageClass = "STANDARD_IA"
	StorageClassIntelligentTiering StorageClass = "INTELLIGENT_TIERING"
	StorageClassDeepArchive        StorageClass = "DEEP_ARCHIVE"
	StorageClassOnezoneIa          StorageClass = "ONEZONE_IA"
	StorageClassGlacier            StorageClass = "GLACIER"
)

func (enum StorageClass) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum StorageClass) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The type of object to apply a tag-based condition to. Valid values are:
type TagTarget string

// Enum values for TagTarget
const (
	TagTargetS3Object TagTarget = "S3_OBJECT"
)

func (enum TagTarget) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum TagTarget) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type Unit string

// Enum values for Unit
const (
	UnitTerabytes Unit = "TERABYTES"
)

func (enum Unit) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Unit) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The field to use to filter the results of a query for account quotas and
// usage data:
type UsageStatisticsFilterKey string

// Enum values for UsageStatisticsFilterKey
const (
	UsageStatisticsFilterKeyAccountId UsageStatisticsFilterKey = "accountId"
)

func (enum UsageStatisticsFilterKey) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum UsageStatisticsFilterKey) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The field to use to sort the results of a query for account quotas and usage
// data. Valid values are:
type UsageStatisticsSortKey string

// Enum values for UsageStatisticsSortKey
const (
	UsageStatisticsSortKeyAccountId UsageStatisticsSortKey = "accountId"
	UsageStatisticsSortKeyTotal     UsageStatisticsSortKey = "total"
)

func (enum UsageStatisticsSortKey) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum UsageStatisticsSortKey) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The name of a usage metric for an account. Possible values are:
type UsageType string

// Enum values for UsageType
const (
	UsageTypeDataInventoryEvaluation UsageType = "DATA_INVENTORY_EVALUATION"
	UsageTypeSensitiveDataDiscovery  UsageType = "SENSITIVE_DATA_DISCOVERY"
)

func (enum UsageType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum UsageType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The type of entity that performed the action on the affected resource. Possible
// values are:
type UserIdentityType string

// Enum values for UserIdentityType
const (
	UserIdentityTypeAssumedRole   UserIdentityType = "AssumedRole"
	UserIdentityTypeIamuser       UserIdentityType = "IAMUser"
	UserIdentityTypeFederatedUser UserIdentityType = "FederatedUser"
	UserIdentityTypeRoot          UserIdentityType = "Root"
	UserIdentityTypeAwsaccount    UserIdentityType = "AWSAccount"
	UserIdentityTypeAwsservice    UserIdentityType = "AWSService"
)

func (enum UserIdentityType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum UserIdentityType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}
