// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies the criteria and other settings for a new findings filter.
type CreateFindingsFilterInput struct {
	_ struct{} `type:"structure"`

	// The action to perform on findings that meet the filter criteria. To suppress
	// (automatically archive) findings that meet the criteria, set this value to
	// ARCHIVE. Valid values are:
	//
	// Action is a required field
	Action FindingsFilterAction `locationName:"action" type:"string" required:"true" enum:"true"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	Description *string `locationName:"description" type:"string"`

	// Specifies, as a map, one or more property-based conditions that filter the
	// results of a query for findings.
	//
	// FindingCriteria is a required field
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure" required:"true"`

	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	Position *int64 `locationName:"position" type:"integer"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateFindingsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFindingsFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFindingsFilterInput"}
	if len(s.Action) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}

	if s.FindingCriteria == nil {
		invalidParams.Add(aws.NewErrParamRequired("FindingCriteria"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateFindingsFilterInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FindingCriteria != nil {
		v := s.FindingCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "findingCriteria", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "position", protocol.Int64Value(v), metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Provides information about a findings filter that was created in response
// to a request.
type CreateFindingsFilterOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s CreateFindingsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateFindingsFilterOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateFindingsFilter = "CreateFindingsFilter"

// CreateFindingsFilterRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Creates and defines the criteria and other settings for a findings filter.
//
//    // Example sending a request using CreateFindingsFilterRequest.
//    req := client.CreateFindingsFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateFindingsFilter
func (c *Client) CreateFindingsFilterRequest(input *CreateFindingsFilterInput) CreateFindingsFilterRequest {
	op := &aws.Operation{
		Name:       opCreateFindingsFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/findingsfilters",
	}

	if input == nil {
		input = &CreateFindingsFilterInput{}
	}

	req := c.newRequest(op, input, &CreateFindingsFilterOutput{})

	return CreateFindingsFilterRequest{Request: req, Input: input, Copy: c.CreateFindingsFilterRequest}
}

// CreateFindingsFilterRequest is the request type for the
// CreateFindingsFilter API operation.
type CreateFindingsFilterRequest struct {
	*aws.Request
	Input *CreateFindingsFilterInput
	Copy  func(*CreateFindingsFilterInput) CreateFindingsFilterRequest
}

// Send marshals and sends the CreateFindingsFilter API request.
func (r CreateFindingsFilterRequest) Send(ctx context.Context) (*CreateFindingsFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateFindingsFilterResponse{
		CreateFindingsFilterOutput: r.Request.Data.(*CreateFindingsFilterOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateFindingsFilterResponse is the response type for the
// CreateFindingsFilter API operation.
type CreateFindingsFilterResponse struct {
	*CreateFindingsFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateFindingsFilter request.
func (r *CreateFindingsFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
