// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteFindingsFilterInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFindingsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFindingsFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFindingsFilterInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFindingsFilterInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteFindingsFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFindingsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFindingsFilterOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteFindingsFilter = "DeleteFindingsFilter"

// DeleteFindingsFilterRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Deletes a findings filter.
//
//    // Example sending a request using DeleteFindingsFilterRequest.
//    req := client.DeleteFindingsFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteFindingsFilter
func (c *Client) DeleteFindingsFilterRequest(input *DeleteFindingsFilterInput) DeleteFindingsFilterRequest {
	op := &aws.Operation{
		Name:       opDeleteFindingsFilter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/findingsfilters/{id}",
	}

	if input == nil {
		input = &DeleteFindingsFilterInput{}
	}

	req := c.newRequest(op, input, &DeleteFindingsFilterOutput{})

	return DeleteFindingsFilterRequest{Request: req, Input: input, Copy: c.DeleteFindingsFilterRequest}
}

// DeleteFindingsFilterRequest is the request type for the
// DeleteFindingsFilter API operation.
type DeleteFindingsFilterRequest struct {
	*aws.Request
	Input *DeleteFindingsFilterInput
	Copy  func(*DeleteFindingsFilterInput) DeleteFindingsFilterRequest
}

// Send marshals and sends the DeleteFindingsFilter API request.
func (r DeleteFindingsFilterRequest) Send(ctx context.Context) (*DeleteFindingsFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFindingsFilterResponse{
		DeleteFindingsFilterOutput: r.Request.Data.(*DeleteFindingsFilterOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFindingsFilterResponse is the response type for the
// DeleteFindingsFilter API operation.
type DeleteFindingsFilterResponse struct {
	*DeleteFindingsFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFindingsFilter request.
func (r *DeleteFindingsFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
