// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteMemberInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMemberInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMemberInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMemberInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMemberInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMemberOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteMember = "DeleteMember"

// DeleteMemberRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Deletes the association between an Amazon Macie master account and an account.
//
//    // Example sending a request using DeleteMemberRequest.
//    req := client.DeleteMemberRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteMember
func (c *Client) DeleteMemberRequest(input *DeleteMemberInput) DeleteMemberRequest {
	op := &aws.Operation{
		Name:       opDeleteMember,
		HTTPMethod: "DELETE",
		HTTPPath:   "/members/{id}",
	}

	if input == nil {
		input = &DeleteMemberInput{}
	}

	req := c.newRequest(op, input, &DeleteMemberOutput{})

	return DeleteMemberRequest{Request: req, Input: input, Copy: c.DeleteMemberRequest}
}

// DeleteMemberRequest is the request type for the
// DeleteMember API operation.
type DeleteMemberRequest struct {
	*aws.Request
	Input *DeleteMemberInput
	Copy  func(*DeleteMemberInput) DeleteMemberRequest
}

// Send marshals and sends the DeleteMember API request.
func (r DeleteMemberRequest) Send(ctx context.Context) (*DeleteMemberResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteMemberResponse{
		DeleteMemberOutput: r.Request.Data.(*DeleteMemberOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteMemberResponse is the response type for the
// DeleteMember API operation.
type DeleteMemberResponse struct {
	*DeleteMemberOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteMember request.
func (r *DeleteMemberResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
