// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeClassificationJobInput struct {
	_ struct{} `type:"structure"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeClassificationJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClassificationJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeClassificationJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeClassificationJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about a classification job, including the current configuration
// settings and status of the job.
type DescribeClassificationJobOutput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	CustomDataIdentifierIds []string `locationName:"customDataIdentifierIds" type:"list"`

	Description *string `locationName:"description" type:"string"`

	InitialRun *bool `locationName:"initialRun" type:"boolean"`

	JobArn *string `locationName:"jobArn" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	// The current status of a classification job. Possible values are:
	JobStatus JobStatus `locationName:"jobStatus" type:"string" enum:"true"`

	// The schedule for running a classification job. Valid values are:
	JobType JobType `locationName:"jobType" type:"string" enum:"true"`

	LastRunTime *time.Time `locationName:"lastRunTime" type:"timestamp" timestampFormat:"iso8601"`

	Name *string `locationName:"name" type:"string"`

	// Specifies which S3 buckets contain the objects that a classification job
	// analyzes, and the scope of that analysis.
	S3JobDefinition *S3JobDefinition `locationName:"s3JobDefinition" type:"structure"`

	SamplingPercentage *int64 `locationName:"samplingPercentage" type:"integer"`

	// Specifies the recurrence pattern for running a classification job.
	ScheduleFrequency *JobScheduleFrequency `locationName:"scheduleFrequency" type:"structure"`

	// Provides processing statistics for a classification job.
	Statistics *Statistics `locationName:"statistics" type:"structure"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeClassificationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeClassificationJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.CustomDataIdentifierIds != nil {
		v := s.CustomDataIdentifierIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "customDataIdentifierIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InitialRun != nil {
		v := *s.InitialRun

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "initialRun", protocol.BoolValue(v), metadata)
	}
	if s.JobArn != nil {
		v := *s.JobArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.JobStatus) > 0 {
		v := s.JobStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.JobType) > 0 {
		v := s.JobType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LastRunTime != nil {
		v := *s.LastRunTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastRunTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3JobDefinition != nil {
		v := s.S3JobDefinition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3JobDefinition", v, metadata)
	}
	if s.SamplingPercentage != nil {
		v := *s.SamplingPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "samplingPercentage", protocol.Int64Value(v), metadata)
	}
	if s.ScheduleFrequency != nil {
		v := s.ScheduleFrequency

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scheduleFrequency", v, metadata)
	}
	if s.Statistics != nil {
		v := s.Statistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "statistics", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opDescribeClassificationJob = "DescribeClassificationJob"

// DescribeClassificationJobRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves information about the status and settings for a classification
// job.
//
//    // Example sending a request using DescribeClassificationJobRequest.
//    req := client.DescribeClassificationJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeClassificationJob
func (c *Client) DescribeClassificationJobRequest(input *DescribeClassificationJobInput) DescribeClassificationJobRequest {
	op := &aws.Operation{
		Name:       opDescribeClassificationJob,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{jobId}",
	}

	if input == nil {
		input = &DescribeClassificationJobInput{}
	}

	req := c.newRequest(op, input, &DescribeClassificationJobOutput{})

	return DescribeClassificationJobRequest{Request: req, Input: input, Copy: c.DescribeClassificationJobRequest}
}

// DescribeClassificationJobRequest is the request type for the
// DescribeClassificationJob API operation.
type DescribeClassificationJobRequest struct {
	*aws.Request
	Input *DescribeClassificationJobInput
	Copy  func(*DescribeClassificationJobInput) DescribeClassificationJobRequest
}

// Send marshals and sends the DescribeClassificationJob API request.
func (r DescribeClassificationJobRequest) Send(ctx context.Context) (*DescribeClassificationJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeClassificationJobResponse{
		DescribeClassificationJobOutput: r.Request.Data.(*DescribeClassificationJobOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeClassificationJobResponse is the response type for the
// DescribeClassificationJob API operation.
type DescribeClassificationJobResponse struct {
	*DescribeClassificationJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeClassificationJob request.
func (r *DescribeClassificationJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
