// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies an account that's associated with the S3 buckets to retrieve aggregated
// statistical data for.
type GetBucketStatisticsInput struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`
}

// String returns the string representation
func (s GetBucketStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketStatisticsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides the results of a query that retrieved aggregated statistical data
// for all the S3 buckets that Amazon Macie monitors and analyzes for an account.
type GetBucketStatisticsOutput struct {
	_ struct{} `type:"structure"`

	BucketCount *int64 `locationName:"bucketCount" type:"long"`

	// Provides information about the number of S3 buckets that are publicly accessible
	// based on a combination of permissions settings for each bucket.
	BucketCountByEffectivePermission *BucketCountByEffectivePermission `locationName:"bucketCountByEffectivePermission" type:"structure"`

	// Provides information about the number of S3 buckets that use certain types
	// of server-side encryption or don't encrypt objects by default.
	BucketCountByEncryptionType *BucketCountByEncryptionType `locationName:"bucketCountByEncryptionType" type:"structure"`

	// Provides information about the number of S3 buckets that are shared with
	// other AWS accounts.
	BucketCountBySharedAccessType *BucketCountBySharedAccessType `locationName:"bucketCountBySharedAccessType" type:"structure"`

	ClassifiableObjectCount *int64 `locationName:"classifiableObjectCount" type:"long"`

	LastUpdated *time.Time `locationName:"lastUpdated" type:"timestamp" timestampFormat:"iso8601"`

	ObjectCount *int64 `locationName:"objectCount" type:"long"`

	SizeInBytes *int64 `locationName:"sizeInBytes" type:"long"`

	SizeInBytesCompressed *int64 `locationName:"sizeInBytesCompressed" type:"long"`
}

// String returns the string representation
func (s GetBucketStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketStatisticsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BucketCount != nil {
		v := *s.BucketCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucketCount", protocol.Int64Value(v), metadata)
	}
	if s.BucketCountByEffectivePermission != nil {
		v := s.BucketCountByEffectivePermission

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "bucketCountByEffectivePermission", v, metadata)
	}
	if s.BucketCountByEncryptionType != nil {
		v := s.BucketCountByEncryptionType

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "bucketCountByEncryptionType", v, metadata)
	}
	if s.BucketCountBySharedAccessType != nil {
		v := s.BucketCountBySharedAccessType

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "bucketCountBySharedAccessType", v, metadata)
	}
	if s.ClassifiableObjectCount != nil {
		v := *s.ClassifiableObjectCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "classifiableObjectCount", protocol.Int64Value(v), metadata)
	}
	if s.LastUpdated != nil {
		v := *s.LastUpdated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdated",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.ObjectCount != nil {
		v := *s.ObjectCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "objectCount", protocol.Int64Value(v), metadata)
	}
	if s.SizeInBytes != nil {
		v := *s.SizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.SizeInBytesCompressed != nil {
		v := *s.SizeInBytesCompressed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sizeInBytesCompressed", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opGetBucketStatistics = "GetBucketStatistics"

// GetBucketStatisticsRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves (queries) aggregated statistical data for all the S3 buckets that
// Amazon Macie monitors and analyzes.
//
//    // Example sending a request using GetBucketStatisticsRequest.
//    req := client.GetBucketStatisticsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetBucketStatistics
func (c *Client) GetBucketStatisticsRequest(input *GetBucketStatisticsInput) GetBucketStatisticsRequest {
	op := &aws.Operation{
		Name:       opGetBucketStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/datasources/s3/statistics",
	}

	if input == nil {
		input = &GetBucketStatisticsInput{}
	}

	req := c.newRequest(op, input, &GetBucketStatisticsOutput{})

	return GetBucketStatisticsRequest{Request: req, Input: input, Copy: c.GetBucketStatisticsRequest}
}

// GetBucketStatisticsRequest is the request type for the
// GetBucketStatistics API operation.
type GetBucketStatisticsRequest struct {
	*aws.Request
	Input *GetBucketStatisticsInput
	Copy  func(*GetBucketStatisticsInput) GetBucketStatisticsRequest
}

// Send marshals and sends the GetBucketStatistics API request.
func (r GetBucketStatisticsRequest) Send(ctx context.Context) (*GetBucketStatisticsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBucketStatisticsResponse{
		GetBucketStatisticsOutput: r.Request.Data.(*GetBucketStatisticsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetBucketStatisticsResponse is the response type for the
// GetBucketStatistics API operation.
type GetBucketStatisticsResponse struct {
	*GetBucketStatisticsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBucketStatistics request.
func (r *GetBucketStatisticsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
