// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies criteria for filtering, grouping, sorting, and paginating the results
// of a query that retrieves aggregated statistical data about findings.
type GetFindingStatisticsInput struct {
	_ struct{} `type:"structure"`

	// Specifies, as a map, one or more property-based conditions that filter the
	// results of a query for findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	// GroupBy is a required field
	GroupBy GroupBy `locationName:"groupBy" type:"string" required:"true" enum:"true"`

	Size *int64 `locationName:"size" type:"integer"`

	// Specifies criteria for sorting the results of a query that retrieves aggregated
	// statistical data about findings.
	SortCriteria *FindingStatisticsSortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s GetFindingStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingStatisticsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFindingStatisticsInput"}
	if len(s.GroupBy) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("GroupBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFindingStatisticsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FindingCriteria != nil {
		v := s.FindingCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "findingCriteria", v, metadata)
	}
	if len(s.GroupBy) > 0 {
		v := s.GroupBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groupBy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "size", protocol.Int64Value(v), metadata)
	}
	if s.SortCriteria != nil {
		v := s.SortCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sortCriteria", v, metadata)
	}
	return nil
}

// Provides the results of a query that retrieved aggregated statistical data
// about findings.
type GetFindingStatisticsOutput struct {
	_ struct{} `type:"structure"`

	CountsByGroup []GroupCount `locationName:"countsByGroup" type:"list"`
}

// String returns the string representation
func (s GetFindingStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFindingStatisticsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CountsByGroup != nil {
		v := s.CountsByGroup

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "countsByGroup", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetFindingStatistics = "GetFindingStatistics"

// GetFindingStatisticsRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves (queries) aggregated statistical data about findings.
//
//    // Example sending a request using GetFindingStatisticsRequest.
//    req := client.GetFindingStatisticsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingStatistics
func (c *Client) GetFindingStatisticsRequest(input *GetFindingStatisticsInput) GetFindingStatisticsRequest {
	op := &aws.Operation{
		Name:       opGetFindingStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/statistics",
	}

	if input == nil {
		input = &GetFindingStatisticsInput{}
	}

	req := c.newRequest(op, input, &GetFindingStatisticsOutput{})

	return GetFindingStatisticsRequest{Request: req, Input: input, Copy: c.GetFindingStatisticsRequest}
}

// GetFindingStatisticsRequest is the request type for the
// GetFindingStatistics API operation.
type GetFindingStatisticsRequest struct {
	*aws.Request
	Input *GetFindingStatisticsInput
	Copy  func(*GetFindingStatisticsInput) GetFindingStatisticsRequest
}

// Send marshals and sends the GetFindingStatistics API request.
func (r GetFindingStatisticsRequest) Send(ctx context.Context) (*GetFindingStatisticsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetFindingStatisticsResponse{
		GetFindingStatisticsOutput: r.Request.Data.(*GetFindingStatisticsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetFindingStatisticsResponse is the response type for the
// GetFindingStatistics API operation.
type GetFindingStatisticsResponse struct {
	*GetFindingStatisticsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetFindingStatistics request.
func (r *GetFindingStatisticsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
