// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetMacieSessionInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetMacieSessionInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMacieSessionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	return nil
}

// Provides information about the current status and configuration settings
// for an Amazon Macie account.
type GetMacieSessionOutput struct {
	_ struct{} `type:"structure"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The frequency with which Amazon Macie publishes updates to policy findings
	// for an account. This includes publishing updates to AWS Security Hub and
	// Amazon EventBridge (formerly called Amazon CloudWatch Events). Valid values
	// are:
	FindingPublishingFrequency FindingPublishingFrequency `locationName:"findingPublishingFrequency" type:"string" enum:"true"`

	ServiceRole *string `locationName:"serviceRole" type:"string"`

	// The status of an Amazon Macie account. Valid values are:
	Status MacieStatus `locationName:"status" type:"string" enum:"true"`

	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetMacieSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMacieSessionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if len(s.FindingPublishingFrequency) > 0 {
		v := s.FindingPublishingFrequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "findingPublishingFrequency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ServiceRole != nil {
		v := *s.ServiceRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

const opGetMacieSession = "GetMacieSession"

// GetMacieSessionRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves information about the current status and configuration settings
// for an Amazon Macie account.
//
//    // Example sending a request using GetMacieSessionRequest.
//    req := client.GetMacieSessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMacieSession
func (c *Client) GetMacieSessionRequest(input *GetMacieSessionInput) GetMacieSessionRequest {
	op := &aws.Operation{
		Name:       opGetMacieSession,
		HTTPMethod: "GET",
		HTTPPath:   "/macie",
	}

	if input == nil {
		input = &GetMacieSessionInput{}
	}

	req := c.newRequest(op, input, &GetMacieSessionOutput{})

	return GetMacieSessionRequest{Request: req, Input: input, Copy: c.GetMacieSessionRequest}
}

// GetMacieSessionRequest is the request type for the
// GetMacieSession API operation.
type GetMacieSessionRequest struct {
	*aws.Request
	Input *GetMacieSessionInput
	Copy  func(*GetMacieSessionInput) GetMacieSessionRequest
}

// Send marshals and sends the GetMacieSession API request.
func (r GetMacieSessionRequest) Send(ctx context.Context) (*GetMacieSessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMacieSessionResponse{
		GetMacieSessionOutput: r.Request.Data.(*GetMacieSessionOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetMacieSessionResponse is the response type for the
// GetMacieSession API operation.
type GetMacieSessionResponse struct {
	*GetMacieSessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMacieSession request.
func (r *GetMacieSessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
