// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetMemberInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMemberInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMemberInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMemberInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMemberInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about an account that's associated with an Amazon Macie
// master account.
type GetMemberOutput struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	Email *string `locationName:"email" type:"string"`

	InvitedAt *time.Time `locationName:"invitedAt" type:"timestamp" timestampFormat:"iso8601"`

	MasterAccountId *string `locationName:"masterAccountId" type:"string"`

	// The current status of the relationship between an account and an associated
	// Amazon Macie master account (inviter account). Possible values are:
	RelationshipStatus RelationshipStatus `locationName:"relationshipStatus" type:"string" enum:"true"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]string `locationName:"tags" type:"map"`

	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMemberOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.MasterAccountId != nil {
		v := *s.MasterAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "masterAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RelationshipStatus) > 0 {
		v := s.RelationshipStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "relationshipStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

const opGetMember = "GetMember"

// GetMemberRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves information about a member account that's associated with an Amazon
// Macie master account.
//
//    // Example sending a request using GetMemberRequest.
//    req := client.GetMemberRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMember
func (c *Client) GetMemberRequest(input *GetMemberInput) GetMemberRequest {
	op := &aws.Operation{
		Name:       opGetMember,
		HTTPMethod: "GET",
		HTTPPath:   "/members/{id}",
	}

	if input == nil {
		input = &GetMemberInput{}
	}

	req := c.newRequest(op, input, &GetMemberOutput{})

	return GetMemberRequest{Request: req, Input: input, Copy: c.GetMemberRequest}
}

// GetMemberRequest is the request type for the
// GetMember API operation.
type GetMemberRequest struct {
	*aws.Request
	Input *GetMemberInput
	Copy  func(*GetMemberInput) GetMemberRequest
}

// Send marshals and sends the GetMember API request.
func (r GetMemberRequest) Send(ctx context.Context) (*GetMemberResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMemberResponse{
		GetMemberOutput: r.Request.Data.(*GetMemberOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetMemberResponse is the response type for the
// GetMember API operation.
type GetMemberResponse struct {
	*GetMemberOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMember request.
func (r *GetMemberResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
