// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetUsageTotalsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetUsageTotalsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUsageTotalsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	return nil
}

// Provides the results of a query that retrieved aggregated usage data for
// an account during the past 30 days.
type GetUsageTotalsOutput struct {
	_ struct{} `type:"structure"`

	UsageTotals []UsageTotal `locationName:"usageTotals" type:"list"`
}

// String returns the string representation
func (s GetUsageTotalsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUsageTotalsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.UsageTotals != nil {
		v := s.UsageTotals

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "usageTotals", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetUsageTotals = "GetUsageTotals"

// GetUsageTotalsRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves (queries) aggregated usage data for an account.
//
//    // Example sending a request using GetUsageTotalsRequest.
//    req := client.GetUsageTotalsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageTotals
func (c *Client) GetUsageTotalsRequest(input *GetUsageTotalsInput) GetUsageTotalsRequest {
	op := &aws.Operation{
		Name:       opGetUsageTotals,
		HTTPMethod: "GET",
		HTTPPath:   "/usage",
	}

	if input == nil {
		input = &GetUsageTotalsInput{}
	}

	req := c.newRequest(op, input, &GetUsageTotalsOutput{})

	return GetUsageTotalsRequest{Request: req, Input: input, Copy: c.GetUsageTotalsRequest}
}

// GetUsageTotalsRequest is the request type for the
// GetUsageTotals API operation.
type GetUsageTotalsRequest struct {
	*aws.Request
	Input *GetUsageTotalsInput
	Copy  func(*GetUsageTotalsInput) GetUsageTotalsRequest
}

// Send marshals and sends the GetUsageTotals API request.
func (r GetUsageTotalsRequest) Send(ctx context.Context) (*GetUsageTotalsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetUsageTotalsResponse{
		GetUsageTotalsOutput: r.Request.Data.(*GetUsageTotalsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetUsageTotalsResponse is the response type for the
// GetUsageTotals API operation.
type GetUsageTotalsResponse struct {
	*GetUsageTotalsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetUsageTotals request.
func (r *GetUsageTotalsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
