// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Provides information about the permissions settings of the bucket-level access
// control list (ACL) for an S3 bucket.
type AccessControlList struct {
	_ struct{} `type:"structure"`

	AllowsPublicReadAccess *bool `locationName:"allowsPublicReadAccess" type:"boolean"`

	AllowsPublicWriteAccess *bool `locationName:"allowsPublicWriteAccess" type:"boolean"`
}

// String returns the string representation
func (s AccessControlList) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessControlList) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowsPublicReadAccess != nil {
		v := *s.AllowsPublicReadAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allowsPublicReadAccess", protocol.BoolValue(v), metadata)
	}
	if s.AllowsPublicWriteAccess != nil {
		v := *s.AllowsPublicWriteAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allowsPublicWriteAccess", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Specifies details for an account to associate with an Amazon Macie master
// account.
type AccountDetail struct {
	_ struct{} `type:"structure"`

	// AccountId is a required field
	AccountId *string `locationName:"accountId" type:"string" required:"true"`

	// Email is a required field
	Email *string `locationName:"email" type:"string" required:"true"`
}

// String returns the string representation
func (s AccountDetail) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountDetail) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccountDetail"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.Email == nil {
		invalidParams.Add(aws.NewErrParamRequired("Email"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about account-level permissions settings that apply
// to an S3 bucket.
type AccountLevelPermissions struct {
	_ struct{} `type:"structure"`

	// Provides information about the block public access settings for an S3 bucket.
	// These settings can apply to a bucket at the account level or bucket level.
	// For detailed information about each setting, see Using Amazon S3 block public
	// access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
	// in the Amazon Simple Storage Service Developer Guide.
	BlockPublicAccess *BlockPublicAccess `locationName:"blockPublicAccess" type:"structure"`
}

// String returns the string representation
func (s AccountLevelPermissions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountLevelPermissions) MarshalFields(e protocol.FieldEncoder) error {
	if s.BlockPublicAccess != nil {
		v := s.BlockPublicAccess

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "blockPublicAccess", v, metadata)
	}
	return nil
}

// Provides information about an account that's designated as a delegated administrator
// of Amazon Macie for an AWS organization.
type AdminAccount struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	// The current status of an account as a delegated administrator of Amazon Macie
	// for an AWS organization.
	Status AdminStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s AdminAccount) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AdminAccount) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about an API operation that an entity invoked for an
// affected resource.
type ApiCallDetails struct {
	_ struct{} `type:"structure"`

	Api *string `locationName:"api" type:"string"`

	ApiServiceName *string `locationName:"apiServiceName" type:"string"`

	FirstSeen *time.Time `locationName:"firstSeen" type:"timestamp" timestampFormat:"iso8601"`

	LastSeen *time.Time `locationName:"lastSeen" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ApiCallDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApiCallDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Api != nil {
		v := *s.Api

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "api", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiServiceName != nil {
		v := *s.ApiServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiServiceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FirstSeen != nil {
		v := *s.FirstSeen

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "firstSeen",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.LastSeen != nil {
		v := *s.LastSeen

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastSeen",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Provides information about an identity that performed an action on an affected
// resource by using temporary security credentials. The credentials were obtained
// using the AssumeRole operation of the AWS Security Token Service (AWS STS)
// API.
type AssumedRole struct {
	_ struct{} `type:"structure"`

	AccessKeyId *string `locationName:"accessKeyId" type:"string"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`

	// Provides information about a session that was created for an entity that
	// performed an action by using temporary security credentials.
	SessionContext *SessionContext `locationName:"sessionContext" type:"structure"`
}

// String returns the string representation
func (s AssumedRole) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssumedRole) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessKeyId != nil {
		v := *s.AccessKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "principalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SessionContext != nil {
		v := s.SessionContext

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sessionContext", v, metadata)
	}
	return nil
}

// Provides information about an AWS account and entity that performed an action
// on an affected resource. The action was performed using the credentials for
// an AWS account other than your own account.
type AwsAccount struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`
}

// String returns the string representation
func (s AwsAccount) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsAccount) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "principalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about an AWS service that performed an action on an
// affected resource.
type AwsService struct {
	_ struct{} `type:"structure"`

	InvokedBy *string `locationName:"invokedBy" type:"string"`
}

// String returns the string representation
func (s AwsService) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsService) MarshalFields(e protocol.FieldEncoder) error {
	if s.InvokedBy != nil {
		v := *s.InvokedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invokedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about a custom data identifier.
type BatchGetCustomDataIdentifierSummary struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Deleted *bool `locationName:"deleted" type:"boolean"`

	Description *string `locationName:"description" type:"string"`

	Id *string `locationName:"id" type:"string"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s BatchGetCustomDataIdentifierSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetCustomDataIdentifierSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Deleted != nil {
		v := *s.Deleted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deleted", protocol.BoolValue(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the block public access settings for an S3 bucket.
// These settings can apply to a bucket at the account level or bucket level.
// For detailed information about each setting, see Using Amazon S3 block public
// access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
// in the Amazon Simple Storage Service Developer Guide.
type BlockPublicAccess struct {
	_ struct{} `type:"structure"`

	BlockPublicAcls *bool `locationName:"blockPublicAcls" type:"boolean"`

	BlockPublicPolicy *bool `locationName:"blockPublicPolicy" type:"boolean"`

	IgnorePublicAcls *bool `locationName:"ignorePublicAcls" type:"boolean"`

	RestrictPublicBuckets *bool `locationName:"restrictPublicBuckets" type:"boolean"`
}

// String returns the string representation
func (s BlockPublicAccess) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BlockPublicAccess) MarshalFields(e protocol.FieldEncoder) error {
	if s.BlockPublicAcls != nil {
		v := *s.BlockPublicAcls

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blockPublicAcls", protocol.BoolValue(v), metadata)
	}
	if s.BlockPublicPolicy != nil {
		v := *s.BlockPublicPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blockPublicPolicy", protocol.BoolValue(v), metadata)
	}
	if s.IgnorePublicAcls != nil {
		v := *s.IgnorePublicAcls

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ignorePublicAcls", protocol.BoolValue(v), metadata)
	}
	if s.RestrictPublicBuckets != nil {
		v := *s.RestrictPublicBuckets

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "restrictPublicBuckets", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Provides information about the number of S3 buckets that are publicly accessible
// based on a combination of permissions settings for each bucket.
type BucketCountByEffectivePermission struct {
	_ struct{} `type:"structure"`

	PubliclyAccessible *int64 `locationName:"publiclyAccessible" type:"long"`

	PubliclyReadable *int64 `locationName:"publiclyReadable" type:"long"`

	PubliclyWritable *int64 `locationName:"publiclyWritable" type:"long"`
}

// String returns the string representation
func (s BucketCountByEffectivePermission) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketCountByEffectivePermission) MarshalFields(e protocol.FieldEncoder) error {
	if s.PubliclyAccessible != nil {
		v := *s.PubliclyAccessible

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "publiclyAccessible", protocol.Int64Value(v), metadata)
	}
	if s.PubliclyReadable != nil {
		v := *s.PubliclyReadable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "publiclyReadable", protocol.Int64Value(v), metadata)
	}
	if s.PubliclyWritable != nil {
		v := *s.PubliclyWritable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "publiclyWritable", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about the number of S3 buckets that use certain types
// of server-side encryption or don't encrypt objects by default.
type BucketCountByEncryptionType struct {
	_ struct{} `type:"structure"`

	KmsManaged *int64 `locationName:"kmsManaged" type:"long"`

	S3Managed *int64 `locationName:"s3Managed" type:"long"`

	Unencrypted *int64 `locationName:"unencrypted" type:"long"`
}

// String returns the string representation
func (s BucketCountByEncryptionType) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketCountByEncryptionType) MarshalFields(e protocol.FieldEncoder) error {
	if s.KmsManaged != nil {
		v := *s.KmsManaged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "kmsManaged", protocol.Int64Value(v), metadata)
	}
	if s.S3Managed != nil {
		v := *s.S3Managed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Managed", protocol.Int64Value(v), metadata)
	}
	if s.Unencrypted != nil {
		v := *s.Unencrypted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unencrypted", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about the number of S3 buckets that are shared with
// other AWS accounts.
type BucketCountBySharedAccessType struct {
	_ struct{} `type:"structure"`

	External *int64 `locationName:"external" type:"long"`

	Internal *int64 `locationName:"internal" type:"long"`

	NotShared *int64 `locationName:"notShared" type:"long"`
}

// String returns the string representation
func (s BucketCountBySharedAccessType) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketCountBySharedAccessType) MarshalFields(e protocol.FieldEncoder) error {
	if s.External != nil {
		v := *s.External

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "external", protocol.Int64Value(v), metadata)
	}
	if s.Internal != nil {
		v := *s.Internal

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "internal", protocol.Int64Value(v), metadata)
	}
	if s.NotShared != nil {
		v := *s.NotShared

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "notShared", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies the operator to use in an attribute-based condition that filters
// the results of a query for information about S3 buckets.
type BucketCriteriaAdditionalProperties struct {
	_ struct{} `type:"structure"`

	Eq []string `locationName:"eq" type:"list"`

	Gt *int64 `locationName:"gt" type:"long"`

	Gte *int64 `locationName:"gte" type:"long"`

	Lt *int64 `locationName:"lt" type:"long"`

	Lte *int64 `locationName:"lte" type:"long"`

	Neq []string `locationName:"neq" type:"list"`

	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation
func (s BucketCriteriaAdditionalProperties) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketCriteriaAdditionalProperties) MarshalFields(e protocol.FieldEncoder) error {
	if s.Eq != nil {
		v := s.Eq

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "eq", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Gt != nil {
		v := *s.Gt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gt", protocol.Int64Value(v), metadata)
	}
	if s.Gte != nil {
		v := *s.Gte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gte", protocol.Int64Value(v), metadata)
	}
	if s.Lt != nil {
		v := *s.Lt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lt", protocol.Int64Value(v), metadata)
	}
	if s.Lte != nil {
		v := *s.Lte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lte", protocol.Int64Value(v), metadata)
	}
	if s.Neq != nil {
		v := s.Neq

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "neq", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about bucket-level permissions settings for an S3 bucket.
type BucketLevelPermissions struct {
	_ struct{} `type:"structure"`

	// Provides information about the permissions settings of the bucket-level access
	// control list (ACL) for an S3 bucket.
	AccessControlList *AccessControlList `locationName:"accessControlList" type:"structure"`

	// Provides information about the block public access settings for an S3 bucket.
	// These settings can apply to a bucket at the account level or bucket level.
	// For detailed information about each setting, see Using Amazon S3 block public
	// access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
	// in the Amazon Simple Storage Service Developer Guide.
	BlockPublicAccess *BlockPublicAccess `locationName:"blockPublicAccess" type:"structure"`

	// Provides information about the permissions settings of a bucket policy for
	// an S3 bucket.
	BucketPolicy *BucketPolicy `locationName:"bucketPolicy" type:"structure"`
}

// String returns the string representation
func (s BucketLevelPermissions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketLevelPermissions) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessControlList != nil {
		v := s.AccessControlList

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessControlList", v, metadata)
	}
	if s.BlockPublicAccess != nil {
		v := s.BlockPublicAccess

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "blockPublicAccess", v, metadata)
	}
	if s.BucketPolicy != nil {
		v := s.BucketPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "bucketPolicy", v, metadata)
	}
	return nil
}

// Provides information about an S3 bucket that Amazon Macie monitors and analyzes.
type BucketMetadata struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	BucketArn *string `locationName:"bucketArn" type:"string"`

	BucketCreatedAt *time.Time `locationName:"bucketCreatedAt" type:"timestamp" timestampFormat:"iso8601"`

	BucketName *string `locationName:"bucketName" type:"string"`

	ClassifiableObjectCount *int64 `locationName:"classifiableObjectCount" type:"long"`

	LastUpdated *time.Time `locationName:"lastUpdated" type:"timestamp" timestampFormat:"iso8601"`

	ObjectCount *int64 `locationName:"objectCount" type:"long"`

	// The total number of objects that are in the bucket, grouped by server-side
	// encryption type. This includes a grouping that reports the total number of
	// objects that aren't encrypted.
	ObjectCountByEncryptionType *ObjectCountByEncryptionType `locationName:"objectCountByEncryptionType" type:"structure"`

	// Provides information about permissions settings that determine whether an
	// S3 bucket is publicly accessible.
	PublicAccess *BucketPublicAccess `locationName:"publicAccess" type:"structure"`

	Region *string `locationName:"region" type:"string"`

	// Provides information about settings that define whether one or more objects
	// in an S3 bucket are replicated to S3 buckets for other AWS accounts and,
	// if so, which accounts.
	ReplicationDetails *ReplicationDetails `locationName:"replicationDetails" type:"structure"`

	SharedAccess SharedAccess `locationName:"sharedAccess" type:"string" enum:"true"`

	SizeInBytes *int64 `locationName:"sizeInBytes" type:"long"`

	SizeInBytesCompressed *int64 `locationName:"sizeInBytesCompressed" type:"long"`

	Tags []KeyValuePair `locationName:"tags" type:"list"`

	Versioning *bool `locationName:"versioning" type:"boolean"`
}

// String returns the string representation
func (s BucketMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BucketArn != nil {
		v := *s.BucketArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucketArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BucketCreatedAt != nil {
		v := *s.BucketCreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucketCreatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.BucketName != nil {
		v := *s.BucketName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucketName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClassifiableObjectCount != nil {
		v := *s.ClassifiableObjectCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "classifiableObjectCount", protocol.Int64Value(v), metadata)
	}
	if s.LastUpdated != nil {
		v := *s.LastUpdated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdated",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.ObjectCount != nil {
		v := *s.ObjectCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "objectCount", protocol.Int64Value(v), metadata)
	}
	if s.ObjectCountByEncryptionType != nil {
		v := s.ObjectCountByEncryptionType

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "objectCountByEncryptionType", v, metadata)
	}
	if s.PublicAccess != nil {
		v := s.PublicAccess

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "publicAccess", v, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReplicationDetails != nil {
		v := s.ReplicationDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "replicationDetails", v, metadata)
	}
	if len(s.SharedAccess) > 0 {
		v := s.SharedAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sharedAccess", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SizeInBytes != nil {
		v := *s.SizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.SizeInBytesCompressed != nil {
		v := *s.SizeInBytesCompressed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sizeInBytesCompressed", protocol.Int64Value(v), metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Versioning != nil {
		v := *s.Versioning

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "versioning", protocol.BoolValue(v), metadata)
	}
	return nil
}

// The account-level and bucket-level permissions settings for an S3 bucket.
type BucketPermissionConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides information about account-level permissions settings that apply
	// to an S3 bucket.
	AccountLevelPermissions *AccountLevelPermissions `locationName:"accountLevelPermissions" type:"structure"`

	// Provides information about bucket-level permissions settings for an S3 bucket.
	BucketLevelPermissions *BucketLevelPermissions `locationName:"bucketLevelPermissions" type:"structure"`
}

// String returns the string representation
func (s BucketPermissionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketPermissionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountLevelPermissions != nil {
		v := s.AccountLevelPermissions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accountLevelPermissions", v, metadata)
	}
	if s.BucketLevelPermissions != nil {
		v := s.BucketLevelPermissions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "bucketLevelPermissions", v, metadata)
	}
	return nil
}

// Provides information about the permissions settings of a bucket policy for
// an S3 bucket.
type BucketPolicy struct {
	_ struct{} `type:"structure"`

	AllowsPublicReadAccess *bool `locationName:"allowsPublicReadAccess" type:"boolean"`

	AllowsPublicWriteAccess *bool `locationName:"allowsPublicWriteAccess" type:"boolean"`
}

// String returns the string representation
func (s BucketPolicy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowsPublicReadAccess != nil {
		v := *s.AllowsPublicReadAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allowsPublicReadAccess", protocol.BoolValue(v), metadata)
	}
	if s.AllowsPublicWriteAccess != nil {
		v := *s.AllowsPublicWriteAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allowsPublicWriteAccess", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Provides information about permissions settings that determine whether an
// S3 bucket is publicly accessible.
type BucketPublicAccess struct {
	_ struct{} `type:"structure"`

	EffectivePermission EffectivePermission `locationName:"effectivePermission" type:"string" enum:"true"`

	// The account-level and bucket-level permissions settings for an S3 bucket.
	PermissionConfiguration *BucketPermissionConfiguration `locationName:"permissionConfiguration" type:"structure"`
}

// String returns the string representation
func (s BucketPublicAccess) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketPublicAccess) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EffectivePermission) > 0 {
		v := s.EffectivePermission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "effectivePermission", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PermissionConfiguration != nil {
		v := s.PermissionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "permissionConfiguration", v, metadata)
	}
	return nil
}

// Specifies criteria for sorting the results of a query for information about
// S3 buckets.
type BucketSortCriteria struct {
	_ struct{} `type:"structure"`

	AttributeName *string `locationName:"attributeName" type:"string"`

	OrderBy OrderBy `locationName:"orderBy" type:"string" enum:"true"`
}

// String returns the string representation
func (s BucketSortCriteria) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketSortCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttributeName != nil {
		v := *s.AttributeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attributeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OrderBy) > 0 {
		v := s.OrderBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "orderBy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about a sensitive data finding, including the classification
// job that produced the finding.
type ClassificationDetails struct {
	_ struct{} `type:"structure"`

	DetailedResultsLocation *string `locationName:"detailedResultsLocation" type:"string"`

	JobArn *string `locationName:"jobArn" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	// Provides detailed information about a sensitive data finding, including the
	// types and number of occurrences of the sensitive data that was found.
	Result *ClassificationResult `locationName:"result" type:"structure"`
}

// String returns the string representation
func (s ClassificationDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ClassificationDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.DetailedResultsLocation != nil {
		v := *s.DetailedResultsLocation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detailedResultsLocation", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobArn != nil {
		v := *s.JobArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Result != nil {
		v := s.Result

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "result", v, metadata)
	}
	return nil
}

// Specifies where to store data classification results, and the encryption
// settings to use when storing results in that location. Currently, you can
// store classification results only in an S3 bucket.
type ClassificationExportConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies an S3 bucket to store data classification results in, and the encryption
	// settings to use when storing results in that bucket.
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation
func (s ClassificationExportConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClassificationExportConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ClassificationExportConfiguration"}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ClassificationExportConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3Destination != nil {
		v := s.S3Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3Destination", v, metadata)
	}
	return nil
}

// Provides detailed information about a sensitive data finding, including the
// types and number of occurrences of the sensitive data that was found.
type ClassificationResult struct {
	_ struct{} `type:"structure"`

	// Provides information about the number of occurrences of the data that produced
	// a sensitive data finding, and the custom data identifiers that detected the
	// data for the finding.
	CustomDataIdentifiers *CustomDataIdentifiers `locationName:"customDataIdentifiers" type:"structure"`

	MimeType *string `locationName:"mimeType" type:"string"`

	// Provides information about the category and number of occurrences of sensitive
	// data that produced a finding.
	SensitiveData []SensitiveDataItem `locationName:"sensitiveData" type:"list"`

	SizeClassified *int64 `locationName:"sizeClassified" type:"long"`

	// Provides information about the status of a sensitive data finding.
	Status *ClassificationResultStatus `locationName:"status" type:"structure"`
}

// String returns the string representation
func (s ClassificationResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ClassificationResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomDataIdentifiers != nil {
		v := s.CustomDataIdentifiers

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "customDataIdentifiers", v, metadata)
	}
	if s.MimeType != nil {
		v := *s.MimeType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "mimeType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SensitiveData != nil {
		v := s.SensitiveData

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sensitiveData", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SizeClassified != nil {
		v := *s.SizeClassified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sizeClassified", protocol.Int64Value(v), metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	return nil
}

// Provides information about the status of a sensitive data finding.
type ClassificationResultStatus struct {
	_ struct{} `type:"structure"`

	Code *string `locationName:"code" type:"string"`

	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s ClassificationResultStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ClassificationResultStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Code != nil {
		v := *s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "code", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Reason != nil {
		v := *s.Reason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "reason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the operator to use in a property-based condition that filters
// the results of a query for findings.
type CriterionAdditionalProperties struct {
	_ struct{} `type:"structure"`

	Eq []string `locationName:"eq" type:"list"`

	Gt *int64 `locationName:"gt" type:"long"`

	Gte *int64 `locationName:"gte" type:"long"`

	Lt *int64 `locationName:"lt" type:"long"`

	Lte *int64 `locationName:"lte" type:"long"`

	Neq []string `locationName:"neq" type:"list"`
}

// String returns the string representation
func (s CriterionAdditionalProperties) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CriterionAdditionalProperties) MarshalFields(e protocol.FieldEncoder) error {
	if s.Eq != nil {
		v := s.Eq

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "eq", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Gt != nil {
		v := *s.Gt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gt", protocol.Int64Value(v), metadata)
	}
	if s.Gte != nil {
		v := *s.Gte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gte", protocol.Int64Value(v), metadata)
	}
	if s.Lt != nil {
		v := *s.Lt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lt", protocol.Int64Value(v), metadata)
	}
	if s.Lte != nil {
		v := *s.Lte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lte", protocol.Int64Value(v), metadata)
	}
	if s.Neq != nil {
		v := s.Neq

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "neq", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Provides information about a custom data identifier.
type CustomDataIdentifierSummary struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	Id *string `locationName:"id" type:"string"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s CustomDataIdentifierSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomDataIdentifierSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the number of occurrences of the data that produced
// a sensitive data finding, and the custom data identifiers that detected the
// data for the finding.
type CustomDataIdentifiers struct {
	_ struct{} `type:"structure"`

	// Provides information about custom data identifiers that produced a sensitive
	// data finding, and the number of occurrences of the data that each identifier
	// detected.
	Detections []CustomDetection `locationName:"detections" type:"list"`

	TotalCount *int64 `locationName:"totalCount" type:"long"`
}

// String returns the string representation
func (s CustomDataIdentifiers) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomDataIdentifiers) MarshalFields(e protocol.FieldEncoder) error {
	if s.Detections != nil {
		v := s.Detections

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "detections", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.TotalCount != nil {
		v := *s.TotalCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "totalCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about a custom data identifier that produced a sensitive
// data finding, and the number of occurrences of the data that it detected
// for the finding.
type CustomDetection struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Count *int64 `locationName:"count" type:"long"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s CustomDetection) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomDetection) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies that a classification job runs once a day, every day. This is an
// empty object.
type DailySchedule struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DailySchedule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DailySchedule) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Provides information about sensitive data that was detected by managed data
// identifiers and produced a sensitive data finding.
type DefaultDetection struct {
	_ struct{} `type:"structure"`

	Count *int64 `locationName:"count" type:"long"`

	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s DefaultDetection) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DefaultDetection) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the domain name of the device that an entity used
// to perform an action on an affected resource.
type DomainDetails struct {
	_ struct{} `type:"structure"`

	DomainName *string `locationName:"domainName" type:"string"`
}

// String returns the string representation
func (s DomainDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about an identity that performed an action on an affected
// resource by using temporary security credentials. The credentials were obtained
// using the GetFederationToken operation of the AWS Security Token Service
// (AWS STS) API.
type FederatedUser struct {
	_ struct{} `type:"structure"`

	AccessKeyId *string `locationName:"accessKeyId" type:"string"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`

	// Provides information about a session that was created for an entity that
	// performed an action by using temporary security credentials.
	SessionContext *SessionContext `locationName:"sessionContext" type:"structure"`
}

// String returns the string representation
func (s FederatedUser) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FederatedUser) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessKeyId != nil {
		v := *s.AccessKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "principalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SessionContext != nil {
		v := s.SessionContext

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sessionContext", v, metadata)
	}
	return nil
}

// Provides information about a finding.
type Finding struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Archived *bool `locationName:"archived" type:"boolean"`

	// The category of the finding. Valid values are:
	Category FindingCategory `locationName:"category" type:"string" enum:"true"`

	// Provides information about a sensitive data finding, including the classification
	// job that produced the finding.
	ClassificationDetails *ClassificationDetails `locationName:"classificationDetails" type:"structure"`

	Count *int64 `locationName:"count" type:"long"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	Id *string `locationName:"id" type:"string"`

	Partition *string `locationName:"partition" type:"string"`

	// Provides the details of a policy finding.
	PolicyDetails *PolicyDetails `locationName:"policyDetails" type:"structure"`

	Region *string `locationName:"region" type:"string"`

	// Provides information about the resources that a finding applies to.
	ResourcesAffected *ResourcesAffected `locationName:"resourcesAffected" type:"structure"`

	Sample *bool `locationName:"sample" type:"boolean"`

	SchemaVersion *string `locationName:"schemaVersion" type:"string"`

	// Provides the numeric score and textual representation of a severity value.
	Severity *Severity `locationName:"severity" type:"structure"`

	Title *string `locationName:"title" type:"string"`

	// The type of finding. Valid values are:
	Type FindingType `locationName:"type" type:"string" enum:"true"`

	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Finding) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Archived != nil {
		v := *s.Archived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "archived", protocol.BoolValue(v), metadata)
	}
	if len(s.Category) > 0 {
		v := s.Category

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "category", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ClassificationDetails != nil {
		v := s.ClassificationDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "classificationDetails", v, metadata)
	}
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Partition != nil {
		v := *s.Partition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyDetails != nil {
		v := s.PolicyDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "policyDetails", v, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourcesAffected != nil {
		v := s.ResourcesAffected

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resourcesAffected", v, metadata)
	}
	if s.Sample != nil {
		v := *s.Sample

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sample", protocol.BoolValue(v), metadata)
	}
	if s.SchemaVersion != nil {
		v := *s.SchemaVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schemaVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Severity != nil {
		v := s.Severity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "severity", v, metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Provides information about an action that occurred for a resource and produced
// a policy finding.
type FindingAction struct {
	_ struct{} `type:"structure"`

	// The type of action that occurred for the resource and produced the policy
	// finding:
	ActionType FindingActionType `locationName:"actionType" type:"string" enum:"true"`

	// Provides information about an API operation that an entity invoked for an
	// affected resource.
	ApiCallDetails *ApiCallDetails `locationName:"apiCallDetails" type:"structure"`
}

// String returns the string representation
func (s FindingAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingAction) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ActionType) > 0 {
		v := s.ActionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "actionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ApiCallDetails != nil {
		v := s.ApiCallDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "apiCallDetails", v, metadata)
	}
	return nil
}

// Provides information about an entity that performed an action that produced
// a policy finding for a resource.
type FindingActor struct {
	_ struct{} `type:"structure"`

	// Provides information about the domain name of the device that an entity used
	// to perform an action on an affected resource.
	DomainDetails *DomainDetails `locationName:"domainDetails" type:"structure"`

	// Provides information about the IP address of the device that an entity used
	// to perform an action on an affected resource.
	IpAddressDetails *IpAddressDetails `locationName:"ipAddressDetails" type:"structure"`

	// Provides information about the type and other characteristics of an entity
	// that performed an action on an affected resource.
	UserIdentity *UserIdentity `locationName:"userIdentity" type:"structure"`
}

// String returns the string representation
func (s FindingActor) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingActor) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainDetails != nil {
		v := s.DomainDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "domainDetails", v, metadata)
	}
	if s.IpAddressDetails != nil {
		v := s.IpAddressDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ipAddressDetails", v, metadata)
	}
	if s.UserIdentity != nil {
		v := s.UserIdentity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "userIdentity", v, metadata)
	}
	return nil
}

// Specifies, as a map, one or more property-based conditions that filter the
// results of a query for findings.
type FindingCriteria struct {
	_ struct{} `type:"structure"`

	// Specifies a condition that defines a property, operator, and value to use
	// to filter the results of a query for findings.
	Criterion map[string]CriterionAdditionalProperties `locationName:"criterion" type:"map"`
}

// String returns the string representation
func (s FindingCriteria) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.Criterion != nil {
		v := s.Criterion

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "criterion", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Specifies criteria for sorting the results of a query that retrieves aggregated
// statistical data about findings.
type FindingStatisticsSortCriteria struct {
	_ struct{} `type:"structure"`

	// The grouping to sort the results by. Valid values are:
	AttributeName FindingStatisticsSortAttributeName `locationName:"attributeName" type:"string" enum:"true"`

	OrderBy OrderBy `locationName:"orderBy" type:"string" enum:"true"`
}

// String returns the string representation
func (s FindingStatisticsSortCriteria) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingStatisticsSortCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AttributeName) > 0 {
		v := s.AttributeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attributeName", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.OrderBy) > 0 {
		v := s.OrderBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "orderBy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about a findings filter.
type FindingsFilterListItem struct {
	_ struct{} `type:"structure"`

	// The action to perform on findings that meet the filter criteria. To suppress
	// (automatically archive) findings that meet the criteria, set this value to
	// ARCHIVE. Valid values are:
	Action FindingsFilterAction `locationName:"action" type:"string" enum:"true"`

	Arn *string `locationName:"arn" type:"string"`

	Id *string `locationName:"id" type:"string"`

	Name *string `locationName:"name" type:"string"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s FindingsFilterListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingsFilterListItem) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Provides a group of results for a query that retrieved aggregated statistical
// data about findings.
type GroupCount struct {
	_ struct{} `type:"structure"`

	Count *int64 `locationName:"count" type:"long"`

	GroupKey *string `locationName:"groupKey" type:"string"`
}

// String returns the string representation
func (s GroupCount) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupCount) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	if s.GroupKey != nil {
		v := *s.GroupKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groupKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about an AWS Identity and Access Management (IAM) user
// who performed an action on an affected resource.
type IamUser struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`

	UserName *string `locationName:"userName" type:"string"`
}

// String returns the string representation
func (s IamUser) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IamUser) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "principalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserName != nil {
		v := *s.UserName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about an Amazon Macie membership invitation that was
// received by an account.
type Invitation struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	InvitationId *string `locationName:"invitationId" type:"string"`

	InvitedAt *time.Time `locationName:"invitedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The current status of the relationship between an account and an associated
	// Amazon Macie master account (inviter account). Possible values are:
	RelationshipStatus RelationshipStatus `locationName:"relationshipStatus" type:"string" enum:"true"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Invitation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitationId != nil {
		v := *s.InvitationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if len(s.RelationshipStatus) > 0 {
		v := s.RelationshipStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "relationshipStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about the IP address of the device that an entity used
// to perform an action on an affected resource.
type IpAddressDetails struct {
	_ struct{} `type:"structure"`

	IpAddressV4 *string `locationName:"ipAddressV4" type:"string"`

	// Provides information about the city that an IP address originated from.
	IpCity *IpCity `locationName:"ipCity" type:"structure"`

	// Provides information about the country that an IP address originated from.
	IpCountry *IpCountry `locationName:"ipCountry" type:"structure"`

	// Provides geographic coordinates that indicate where a specified IP address
	// originated from.
	IpGeoLocation *IpGeoLocation `locationName:"ipGeoLocation" type:"structure"`

	// Provides information about the registered owner of an IP address.
	IpOwner *IpOwner `locationName:"ipOwner" type:"structure"`
}

// String returns the string representation
func (s IpAddressDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IpAddressDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.IpAddressV4 != nil {
		v := *s.IpAddressV4

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ipAddressV4", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IpCity != nil {
		v := s.IpCity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ipCity", v, metadata)
	}
	if s.IpCountry != nil {
		v := s.IpCountry

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ipCountry", v, metadata)
	}
	if s.IpGeoLocation != nil {
		v := s.IpGeoLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ipGeoLocation", v, metadata)
	}
	if s.IpOwner != nil {
		v := s.IpOwner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ipOwner", v, metadata)
	}
	return nil
}

// Provides information about the city that an IP address originated from.
type IpCity struct {
	_ struct{} `type:"structure"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s IpCity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IpCity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the country that an IP address originated from.
type IpCountry struct {
	_ struct{} `type:"structure"`

	Code *string `locationName:"code" type:"string"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s IpCountry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IpCountry) MarshalFields(e protocol.FieldEncoder) error {
	if s.Code != nil {
		v := *s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "code", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides geographic coordinates that indicate where a specified IP address
// originated from.
type IpGeoLocation struct {
	_ struct{} `type:"structure"`

	Lat *float64 `locationName:"lat" type:"double"`

	Lon *float64 `locationName:"lon" type:"double"`
}

// String returns the string representation
func (s IpGeoLocation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IpGeoLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Lat != nil {
		v := *s.Lat

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lat", protocol.Float64Value(v), metadata)
	}
	if s.Lon != nil {
		v := *s.Lon

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lon", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Provides information about the registered owner of an IP address.
type IpOwner struct {
	_ struct{} `type:"structure"`

	Asn *string `locationName:"asn" type:"string"`

	AsnOrg *string `locationName:"asnOrg" type:"string"`

	Isp *string `locationName:"isp" type:"string"`

	Org *string `locationName:"org" type:"string"`
}

// String returns the string representation
func (s IpOwner) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IpOwner) MarshalFields(e protocol.FieldEncoder) error {
	if s.Asn != nil {
		v := *s.Asn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "asn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AsnOrg != nil {
		v := *s.AsnOrg

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "asnOrg", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Isp != nil {
		v := *s.Isp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Org != nil {
		v := *s.Org

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "org", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the recurrence pattern for running a classification job.
type JobScheduleFrequency struct {
	_ struct{} `type:"structure"`

	// Specifies that a classification job runs once a day, every day. This is an
	// empty object.
	DailySchedule *DailySchedule `locationName:"dailySchedule" type:"structure"`

	// Specifies a monthly recurrence pattern for running a classification job.
	MonthlySchedule *MonthlySchedule `locationName:"monthlySchedule" type:"structure"`

	// Specifies a weekly recurrence pattern for running a classification job.
	WeeklySchedule *WeeklySchedule `locationName:"weeklySchedule" type:"structure"`
}

// String returns the string representation
func (s JobScheduleFrequency) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobScheduleFrequency) MarshalFields(e protocol.FieldEncoder) error {
	if s.DailySchedule != nil {
		v := s.DailySchedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dailySchedule", v, metadata)
	}
	if s.MonthlySchedule != nil {
		v := s.MonthlySchedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "monthlySchedule", v, metadata)
	}
	if s.WeeklySchedule != nil {
		v := s.WeeklySchedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "weeklySchedule", v, metadata)
	}
	return nil
}

// Specifies a property- or tag-based condition that defines criteria for including
// or excluding objects from a classification job.
type JobScopeTerm struct {
	_ struct{} `type:"structure"`

	// Specifies a property-based condition that determines whether an object is
	// included or excluded from a classification job.
	SimpleScopeTerm *SimpleScopeTerm `locationName:"simpleScopeTerm" type:"structure"`

	// Specifies a tag-based condition that determines whether an object is included
	// or excluded from a classification job.
	TagScopeTerm *TagScopeTerm `locationName:"tagScopeTerm" type:"structure"`
}

// String returns the string representation
func (s JobScopeTerm) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobScopeTerm) MarshalFields(e protocol.FieldEncoder) error {
	if s.SimpleScopeTerm != nil {
		v := s.SimpleScopeTerm

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "simpleScopeTerm", v, metadata)
	}
	if s.TagScopeTerm != nil {
		v := s.TagScopeTerm

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "tagScopeTerm", v, metadata)
	}
	return nil
}

// Specifies one or more property- and tag-based conditions that define criteria
// for including or excluding objects from a classification job.
type JobScopingBlock struct {
	_ struct{} `type:"structure"`

	And []JobScopeTerm `locationName:"and" type:"list"`
}

// String returns the string representation
func (s JobScopingBlock) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobScopingBlock) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "and", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Provides information about a classification job, including the current status
// of the job.
type JobSummary struct {
	_ struct{} `type:"structure"`

	BucketDefinitions []S3BucketDefinitionForJob `locationName:"bucketDefinitions" type:"list"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	JobId *string `locationName:"jobId" type:"string"`

	// The current status of a classification job. Possible values are:
	JobStatus JobStatus `locationName:"jobStatus" type:"string" enum:"true"`

	// The schedule for running a classification job. Valid values are:
	JobType JobType `locationName:"jobType" type:"string" enum:"true"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.BucketDefinitions != nil {
		v := s.BucketDefinitions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "bucketDefinitions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.JobStatus) > 0 {
		v := s.JobStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.JobType) > 0 {
		v := s.JobType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the tags that are associated with an S3 bucket
// or object. Each tag consists of a required tag key and an associated tag
// value.
type KeyValuePair struct {
	_ struct{} `type:"structure"`

	Key *string `locationName:"key" type:"string"`

	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s KeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s KeyValuePair) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies criteria for filtering the results of a request for information
// about classification jobs.
type ListJobsFilterCriteria struct {
	_ struct{} `type:"structure"`

	Excludes []ListJobsFilterTerm `locationName:"excludes" type:"list"`

	Includes []ListJobsFilterTerm `locationName:"includes" type:"list"`
}

// String returns the string representation
func (s ListJobsFilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListJobsFilterCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.Excludes != nil {
		v := s.Excludes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "excludes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Includes != nil {
		v := s.Includes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "includes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies a condition that filters the results of a request for information
// about classification jobs. Each condition consists of a property, an operator,
// and one or more values.
type ListJobsFilterTerm struct {
	_ struct{} `type:"structure"`

	// The operator to use in a condition. Valid values are:
	Comparator JobComparator `locationName:"comparator" type:"string" enum:"true"`

	// The property to use to filter the results. Valid values are:
	Key ListJobsFilterKey `locationName:"key" type:"string" enum:"true"`

	Values []string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s ListJobsFilterTerm) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListJobsFilterTerm) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Comparator) > 0 {
		v := s.Comparator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "comparator", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Key) > 0 {
		v := s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Specifies criteria for sorting the results of a request for information about
// classification jobs.
type ListJobsSortCriteria struct {
	_ struct{} `type:"structure"`

	// The property to sort the results by. Valid values are:
	AttributeName ListJobsSortAttributeName `locationName:"attributeName" type:"string" enum:"true"`

	OrderBy OrderBy `locationName:"orderBy" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListJobsSortCriteria) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListJobsSortCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AttributeName) > 0 {
		v := s.AttributeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attributeName", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.OrderBy) > 0 {
		v := s.OrderBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "orderBy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about an account that's associated with an Amazon Macie
// master account.
type Member struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	Email *string `locationName:"email" type:"string"`

	InvitedAt *time.Time `locationName:"invitedAt" type:"timestamp" timestampFormat:"iso8601"`

	MasterAccountId *string `locationName:"masterAccountId" type:"string"`

	// The current status of the relationship between an account and an associated
	// Amazon Macie master account (inviter account). Possible values are:
	RelationshipStatus RelationshipStatus `locationName:"relationshipStatus" type:"string" enum:"true"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]string `locationName:"tags" type:"map"`

	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Member) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.MasterAccountId != nil {
		v := *s.MasterAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "masterAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RelationshipStatus) > 0 {
		v := s.RelationshipStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "relationshipStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Specifies a monthly recurrence pattern for running a classification job.
type MonthlySchedule struct {
	_ struct{} `type:"structure"`

	DayOfMonth *int64 `locationName:"dayOfMonth" type:"integer"`
}

// String returns the string representation
func (s MonthlySchedule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MonthlySchedule) MarshalFields(e protocol.FieldEncoder) error {
	if s.DayOfMonth != nil {
		v := *s.DayOfMonth

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dayOfMonth", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The total number of objects that are in the bucket, grouped by server-side
// encryption type. This includes a grouping that reports the total number of
// objects that aren't encrypted.
type ObjectCountByEncryptionType struct {
	_ struct{} `type:"structure"`

	CustomerManaged *int64 `locationName:"customerManaged" type:"long"`

	KmsManaged *int64 `locationName:"kmsManaged" type:"long"`

	S3Managed *int64 `locationName:"s3Managed" type:"long"`

	Unencrypted *int64 `locationName:"unencrypted" type:"long"`
}

// String returns the string representation
func (s ObjectCountByEncryptionType) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectCountByEncryptionType) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomerManaged != nil {
		v := *s.CustomerManaged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "customerManaged", protocol.Int64Value(v), metadata)
	}
	if s.KmsManaged != nil {
		v := *s.KmsManaged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "kmsManaged", protocol.Int64Value(v), metadata)
	}
	if s.S3Managed != nil {
		v := *s.S3Managed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Managed", protocol.Int64Value(v), metadata)
	}
	if s.Unencrypted != nil {
		v := *s.Unencrypted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unencrypted", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides the details of a policy finding.
type PolicyDetails struct {
	_ struct{} `type:"structure"`

	// Provides information about an action that occurred for a resource and produced
	// a policy finding.
	Action *FindingAction `locationName:"action" type:"structure"`

	// Provides information about an entity that performed an action that produced
	// a policy finding for a resource.
	Actor *FindingActor `locationName:"actor" type:"structure"`
}

// String returns the string representation
func (s PolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PolicyDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Action != nil {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "action", v, metadata)
	}
	if s.Actor != nil {
		v := s.Actor

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "actor", v, metadata)
	}
	return nil
}

// Provides information about settings that define whether one or more objects
// in an S3 bucket are replicated to S3 buckets for other AWS accounts and,
// if so, which accounts.
type ReplicationDetails struct {
	_ struct{} `type:"structure"`

	Replicated *bool `locationName:"replicated" type:"boolean"`

	ReplicatedExternally *bool `locationName:"replicatedExternally" type:"boolean"`

	ReplicationAccounts []string `locationName:"replicationAccounts" type:"list"`
}

// String returns the string representation
func (s ReplicationDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Replicated != nil {
		v := *s.Replicated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "replicated", protocol.BoolValue(v), metadata)
	}
	if s.ReplicatedExternally != nil {
		v := *s.ReplicatedExternally

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "replicatedExternally", protocol.BoolValue(v), metadata)
	}
	if s.ReplicationAccounts != nil {
		v := s.ReplicationAccounts

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "replicationAccounts", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Provides information about the resources that a finding applies to.
type ResourcesAffected struct {
	_ struct{} `type:"structure"`

	// Provides information about an S3 bucket that a finding applies to.
	S3Bucket *S3Bucket `locationName:"s3Bucket" type:"structure"`

	// Provides information about an S3 object that a finding applies to.
	S3Object *S3Object `locationName:"s3Object" type:"structure"`
}

// String returns the string representation
func (s ResourcesAffected) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourcesAffected) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3Bucket != nil {
		v := s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3Bucket", v, metadata)
	}
	if s.S3Object != nil {
		v := s.S3Object

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3Object", v, metadata)
	}
	return nil
}

// Provides information about an S3 bucket that a finding applies to.
type S3Bucket struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// Provides information about the server-side encryption settings for an S3
	// bucket or object.
	DefaultServerSideEncryption *ServerSideEncryption `locationName:"defaultServerSideEncryption" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	// Provides information about the user who owns an S3 bucket.
	Owner *S3BucketOwner `locationName:"owner" type:"structure"`

	// Provides information about permissions settings that determine whether an
	// S3 bucket is publicly accessible.
	PublicAccess *BucketPublicAccess `locationName:"publicAccess" type:"structure"`

	// Provides information about the tags that are associated with an S3 bucket
	// or object. Each tag consists of a required tag key and an associated tag
	// value.
	Tags []KeyValuePair `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s S3Bucket) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Bucket) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.DefaultServerSideEncryption != nil {
		v := s.DefaultServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "defaultServerSideEncryption", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "owner", v, metadata)
	}
	if s.PublicAccess != nil {
		v := s.PublicAccess

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "publicAccess", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies which S3 buckets contain the objects that a classification job
// analyzes.
type S3BucketDefinitionForJob struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Buckets []string `locationName:"buckets" type:"list"`
}

// String returns the string representation
func (s S3BucketDefinitionForJob) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3BucketDefinitionForJob) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Buckets != nil {
		v := s.Buckets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "buckets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Provides information about the user who owns an S3 bucket.
type S3BucketOwner struct {
	_ struct{} `type:"structure"`

	DisplayName *string `locationName:"displayName" type:"string"`

	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s S3BucketOwner) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3BucketOwner) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "displayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies an S3 bucket to store data classification results in, and the encryption
// settings to use when storing results in that bucket.
type S3Destination struct {
	_ struct{} `type:"structure"`

	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	KeyPrefix *string `locationName:"keyPrefix" type:"string"`

	// KmsKeyArn is a required field
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Destination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Destination"}

	if s.BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketName"))
	}

	if s.KmsKeyArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("KmsKeyArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Destination) MarshalFields(e protocol.FieldEncoder) error {
	if s.BucketName != nil {
		v := *s.BucketName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucketName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyPrefix != nil {
		v := *s.KeyPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KmsKeyArn != nil {
		v := *s.KmsKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "kmsKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies which S3 buckets contain the objects that a classification job
// analyzes, and the scope of that analysis.
type S3JobDefinition struct {
	_ struct{} `type:"structure"`

	BucketDefinitions []S3BucketDefinitionForJob `locationName:"bucketDefinitions" type:"list"`

	// Specifies one or more property- and tag-based conditions that refine the
	// scope of a classification job. These conditions define criteria that determine
	// which objects a job analyzes.
	Scoping *Scoping `locationName:"scoping" type:"structure"`
}

// String returns the string representation
func (s S3JobDefinition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3JobDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.BucketDefinitions != nil {
		v := s.BucketDefinitions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "bucketDefinitions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Scoping != nil {
		v := s.Scoping

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scoping", v, metadata)
	}
	return nil
}

// Provides information about an S3 object that a finding applies to.
type S3Object struct {
	_ struct{} `type:"structure"`

	BucketArn *string `locationName:"bucketArn" type:"string"`

	ETag *string `locationName:"eTag" type:"string"`

	Extension *string `locationName:"extension" type:"string"`

	Key *string `locationName:"key" type:"string"`

	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"iso8601"`

	Path *string `locationName:"path" type:"string"`

	PublicAccess *bool `locationName:"publicAccess" type:"boolean"`

	// Provides information about the server-side encryption settings for an S3
	// bucket or object.
	ServerSideEncryption *ServerSideEncryption `locationName:"serverSideEncryption" type:"structure"`

	Size *int64 `locationName:"size" type:"long"`

	// The storage class of the S3 bucket or object. Possible values are:
	StorageClass StorageClass `locationName:"storageClass" type:"string" enum:"true"`

	// Provides information about the tags that are associated with an S3 bucket
	// or object. Each tag consists of a required tag key and an associated tag
	// value.
	Tags []KeyValuePair `locationName:"tags" type:"list"`

	VersionId *string `locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s S3Object) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Object) MarshalFields(e protocol.FieldEncoder) error {
	if s.BucketArn != nil {
		v := *s.BucketArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucketArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "eTag", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Extension != nil {
		v := *s.Extension

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "extension", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastModified",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PublicAccess != nil {
		v := *s.PublicAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "publicAccess", protocol.BoolValue(v), metadata)
	}
	if s.ServerSideEncryption != nil {
		v := s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "serverSideEncryption", v, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "size", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "storageClass", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "versionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies one or more property- and tag-based conditions that refine the
// scope of a classification job. These conditions define criteria that determine
// which objects a job analyzes.
type Scoping struct {
	_ struct{} `type:"structure"`

	// Specifies one or more property- and tag-based conditions that define criteria
	// for including or excluding objects from a classification job.
	Excludes *JobScopingBlock `locationName:"excludes" type:"structure"`

	// Specifies one or more property- and tag-based conditions that define criteria
	// for including or excluding objects from a classification job.
	Includes *JobScopingBlock `locationName:"includes" type:"structure"`
}

// String returns the string representation
func (s Scoping) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scoping) MarshalFields(e protocol.FieldEncoder) error {
	if s.Excludes != nil {
		v := s.Excludes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "excludes", v, metadata)
	}
	if s.Includes != nil {
		v := s.Includes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "includes", v, metadata)
	}
	return nil
}

// Provides information about the category, type, and number of occurrences
// of sensitive data that produced a finding.
type SensitiveDataItem struct {
	_ struct{} `type:"structure"`

	// The category of sensitive data that was detected and produced the finding.
	// Possible values are:
	Category SensitiveDataItemCategory `locationName:"category" type:"string" enum:"true"`

	// Provides information about sensitive data that was detected by managed data
	// identifiers and produced a sensitive data finding, and the number of occurrences
	// of each type of sensitive data that was detected.
	Detections []DefaultDetection `locationName:"detections" type:"list"`

	TotalCount *int64 `locationName:"totalCount" type:"long"`
}

// String returns the string representation
func (s SensitiveDataItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SensitiveDataItem) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Category) > 0 {
		v := s.Category

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "category", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Detections != nil {
		v := s.Detections

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "detections", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.TotalCount != nil {
		v := *s.TotalCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "totalCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about the server-side encryption settings for an S3
// bucket or object.
type ServerSideEncryption struct {
	_ struct{} `type:"structure"`

	// The type of server-side encryption that's used to encrypt objects in the
	// S3 bucket. Valid values are:
	EncryptionType EncryptionType `locationName:"encryptionType" type:"string" enum:"true"`

	KmsMasterKeyId *string `locationName:"kmsMasterKeyId" type:"string"`
}

// String returns the string representation
func (s ServerSideEncryption) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServerSideEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EncryptionType) > 0 {
		v := s.EncryptionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "encryptionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.KmsMasterKeyId != nil {
		v := *s.KmsMasterKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "kmsMasterKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies a current quota for an account.
type ServiceLimit struct {
	_ struct{} `type:"structure"`

	IsServiceLimited *bool `locationName:"isServiceLimited" type:"boolean"`

	Unit Unit `locationName:"unit" type:"string" enum:"true"`

	Value *int64 `locationName:"value" type:"long"`
}

// String returns the string representation
func (s ServiceLimit) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServiceLimit) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsServiceLimited != nil {
		v := *s.IsServiceLimited

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isServiceLimited", protocol.BoolValue(v), metadata)
	}
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides information about a session that was created for an entity that
// performed an action by using temporary security credentials.
type SessionContext struct {
	_ struct{} `type:"structure"`

	// Provides information about the context in which temporary security credentials
	// were issued to an entity.
	Attributes *SessionContextAttributes `locationName:"attributes" type:"structure"`

	// Provides information about the source and type of temporary security credentials
	// that were issued to an entity.
	SessionIssuer *SessionIssuer `locationName:"sessionIssuer" type:"structure"`
}

// String returns the string representation
func (s SessionContext) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SessionContext) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "attributes", v, metadata)
	}
	if s.SessionIssuer != nil {
		v := s.SessionIssuer

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sessionIssuer", v, metadata)
	}
	return nil
}

// Provides information about the context in which temporary security credentials
// were issued to an entity.
type SessionContextAttributes struct {
	_ struct{} `type:"structure"`

	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"iso8601"`

	MfaAuthenticated *bool `locationName:"mfaAuthenticated" type:"boolean"`
}

// String returns the string representation
func (s SessionContextAttributes) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SessionContextAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.MfaAuthenticated != nil {
		v := *s.MfaAuthenticated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "mfaAuthenticated", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Provides information about the source and type of temporary security credentials
// that were issued to an entity.
type SessionIssuer struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`

	Type *string `locationName:"type" type:"string"`

	UserName *string `locationName:"userName" type:"string"`
}

// String returns the string representation
func (s SessionIssuer) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SessionIssuer) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "principalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserName != nil {
		v := *s.UserName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides the numeric score and textual representation of a severity value.
type Severity struct {
	_ struct{} `type:"structure"`

	// The textual representation of the finding's severity. Possible values are:
	Description SeverityDescription `locationName:"description" type:"string" enum:"true"`

	Score *int64 `locationName:"score" type:"long"`
}

// String returns the string representation
func (s Severity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Severity) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Description) > 0 {
		v := s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Score != nil {
		v := *s.Score

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "score", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies a property-based condition that determines whether an object is
// included or excluded from a classification job.
type SimpleScopeTerm struct {
	_ struct{} `type:"structure"`

	// The operator to use in a condition. Valid values are:
	Comparator JobComparator `locationName:"comparator" type:"string" enum:"true"`

	// The property to use in a condition that determines which objects are analyzed
	// by a classification job. Valid values are:
	Key ScopeFilterKey `locationName:"key" type:"string" enum:"true"`

	Values []string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s SimpleScopeTerm) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimpleScopeTerm) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Comparator) > 0 {
		v := s.Comparator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "comparator", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Key) > 0 {
		v := s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Specifies criteria for sorting the results of a request for information about
// findings.
type SortCriteria struct {
	_ struct{} `type:"structure"`

	AttributeName *string `locationName:"attributeName" type:"string"`

	OrderBy OrderBy `locationName:"orderBy" type:"string" enum:"true"`
}

// String returns the string representation
func (s SortCriteria) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SortCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttributeName != nil {
		v := *s.AttributeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attributeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OrderBy) > 0 {
		v := s.OrderBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "orderBy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides processing statistics for a classification job.
type Statistics struct {
	_ struct{} `type:"structure"`

	ApproximateNumberOfObjectsToProcess *float64 `locationName:"approximateNumberOfObjectsToProcess" type:"double"`

	NumberOfRuns *float64 `locationName:"numberOfRuns" type:"double"`
}

// String returns the string representation
func (s Statistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Statistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApproximateNumberOfObjectsToProcess != nil {
		v := *s.ApproximateNumberOfObjectsToProcess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "approximateNumberOfObjectsToProcess", protocol.Float64Value(v), metadata)
	}
	if s.NumberOfRuns != nil {
		v := *s.NumberOfRuns

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfRuns", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Specifies a tag-based condition that determines whether an object is included
// or excluded from a classification job.
type TagScopeTerm struct {
	_ struct{} `type:"structure"`

	// The operator to use in a condition. Valid values are:
	Comparator JobComparator `locationName:"comparator" type:"string" enum:"true"`

	Key *string `locationName:"key" type:"string"`

	TagValues []TagValuePair `locationName:"tagValues" type:"list"`

	// The type of object to apply a tag-based condition to. Valid values are:
	Target TagTarget `locationName:"target" type:"string" enum:"true"`
}

// String returns the string representation
func (s TagScopeTerm) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TagScopeTerm) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Comparator) > 0 {
		v := s.Comparator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "comparator", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TagValues != nil {
		v := s.TagValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tagValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Target) > 0 {
		v := s.Target

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "target", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Specifies a tag key and value, as a pair, to use in a tag-based condition
// for a classification job.
type TagValuePair struct {
	_ struct{} `type:"structure"`

	Key *string `locationName:"key" type:"string"`

	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s TagValuePair) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TagValuePair) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about an account-related request that hasn't been processed.
type UnprocessedAccount struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	// The source of an error, issue, or delay. Possible values are:
	ErrorCode ErrorCode `locationName:"errorCode" type:"string" enum:"true"`

	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation
func (s UnprocessedAccount) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnprocessedAccount) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ErrorCode) > 0 {
		v := s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides data for a specific usage metric and the corresponding quota for
// an account. The value for the metric is an aggregated value that reports
// usage during the past 30 days.
type UsageByAccount struct {
	_ struct{} `type:"structure"`

	// The type of currency that data for a usage metric is reported in. Possible
	// values are:
	Currency Currency `locationName:"currency" type:"string" enum:"true"`

	EstimatedCost *string `locationName:"estimatedCost" type:"string"`

	// Specifies a current quota for an account.
	ServiceLimit *ServiceLimit `locationName:"serviceLimit" type:"structure"`

	// The name of a usage metric for an account. Possible values are:
	Type UsageType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s UsageByAccount) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UsageByAccount) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Currency) > 0 {
		v := s.Currency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "currency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EstimatedCost != nil {
		v := *s.EstimatedCost

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "estimatedCost", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceLimit != nil {
		v := s.ServiceLimit

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "serviceLimit", v, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides quota and aggregated usage data for an account.
type UsageRecord struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	FreeTrialStartDate *time.Time `locationName:"freeTrialStartDate" type:"timestamp" timestampFormat:"iso8601"`

	Usage []UsageByAccount `locationName:"usage" type:"list"`
}

// String returns the string representation
func (s UsageRecord) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UsageRecord) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FreeTrialStartDate != nil {
		v := *s.FreeTrialStartDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "freeTrialStartDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Usage != nil {
		v := s.Usage

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "usage", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies criteria for filtering the results of a query for account quotas
// and usage data.
type UsageStatisticsFilter struct {
	_ struct{} `type:"structure"`

	// The field to use to filter the results of a query for account quotas and
	// usage data:
	Key UsageStatisticsFilterKey `locationName:"key" type:"string" enum:"true"`

	Values []string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s UsageStatisticsFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UsageStatisticsFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Key) > 0 {
		v := s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Specifies criteria for sorting the results of a query for account quotas
// and usage data.
type UsageStatisticsSortBy struct {
	_ struct{} `type:"structure"`

	// The field to use to sort the results of a query for account quotas and usage
	// data. Valid values are:
	Key UsageStatisticsSortKey `locationName:"key" type:"string" enum:"true"`

	OrderBy OrderBy `locationName:"orderBy" type:"string" enum:"true"`
}

// String returns the string representation
func (s UsageStatisticsSortBy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UsageStatisticsSortBy) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Key) > 0 {
		v := s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.OrderBy) > 0 {
		v := s.OrderBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "orderBy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides aggregated data for a usage metric. The value for the metric reports
// usage data for an account during the past 30 days.
type UsageTotal struct {
	_ struct{} `type:"structure"`

	// The type of currency that data for a usage metric is reported in. Possible
	// values are:
	Currency Currency `locationName:"currency" type:"string" enum:"true"`

	EstimatedCost *string `locationName:"estimatedCost" type:"string"`

	// The name of a usage metric for an account. Possible values are:
	Type UsageType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s UsageTotal) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UsageTotal) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Currency) > 0 {
		v := s.Currency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "currency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EstimatedCost != nil {
		v := *s.EstimatedCost

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "estimatedCost", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about the type and other characteristics of an entity
// that performed an action on an affected resource.
type UserIdentity struct {
	_ struct{} `type:"structure"`

	// Provides information about an identity that performed an action on an affected
	// resource by using temporary security credentials. The credentials were obtained
	// using the AssumeRole operation of the AWS Security Token Service (AWS STS)
	// API.
	AssumedRole *AssumedRole `locationName:"assumedRole" type:"structure"`

	// Provides information about an AWS account and entity that performed an action
	// on an affected resource. The action was performed using the credentials for
	// an AWS account other than your own account.
	AwsAccount *AwsAccount `locationName:"awsAccount" type:"structure"`

	// Provides information about an AWS service that performed an action on an
	// affected resource.
	AwsService *AwsService `locationName:"awsService" type:"structure"`

	// Provides information about an identity that performed an action on an affected
	// resource by using temporary security credentials. The credentials were obtained
	// using the GetFederationToken operation of the AWS Security Token Service
	// (AWS STS) API.
	FederatedUser *FederatedUser `locationName:"federatedUser" type:"structure"`

	// Provides information about an AWS Identity and Access Management (IAM) user
	// who performed an action on an affected resource.
	IamUser *IamUser `locationName:"iamUser" type:"structure"`

	// Provides information about an AWS account and entity that performed an action
	// on an affected resource. The action was performed using the credentials for
	// your AWS account.
	Root *UserIdentityRoot `locationName:"root" type:"structure"`

	// The type of entity that performed the action on the affected resource. Possible
	// values are:
	Type UserIdentityType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s UserIdentity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserIdentity) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssumedRole != nil {
		v := s.AssumedRole

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "assumedRole", v, metadata)
	}
	if s.AwsAccount != nil {
		v := s.AwsAccount

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "awsAccount", v, metadata)
	}
	if s.AwsService != nil {
		v := s.AwsService

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "awsService", v, metadata)
	}
	if s.FederatedUser != nil {
		v := s.FederatedUser

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "federatedUser", v, metadata)
	}
	if s.IamUser != nil {
		v := s.IamUser

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "iamUser", v, metadata)
	}
	if s.Root != nil {
		v := s.Root

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "root", v, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about an AWS account and entity that performed an action
// on an affected resource. The action was performed using the credentials for
// your AWS account.
type UserIdentityRoot struct {
	_ struct{} `type:"structure"`

	AccountId *string `locationName:"accountId" type:"string"`

	Arn *string `locationName:"arn" type:"string"`

	PrincipalId *string `locationName:"principalId" type:"string"`
}

// String returns the string representation
func (s UserIdentityRoot) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserIdentityRoot) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "principalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies a weekly recurrence pattern for running a classification job.
type WeeklySchedule struct {
	_ struct{} `type:"structure"`

	DayOfWeek DayOfWeek `locationName:"dayOfWeek" type:"string" enum:"true"`
}

// String returns the string representation
func (s WeeklySchedule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WeeklySchedule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DayOfWeek) > 0 {
		v := s.DayOfWeek

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dayOfWeek", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}
