// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package marketplacecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeChangeSetInput struct {
	_ struct{} `type:"structure"`

	// Required. The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `location:"querystring" locationName:"catalog" min:"1" type:"string" required:"true"`

	// Required. The unique identifier for the StartChangeSet request that you want
	// to describe the details for.
	//
	// ChangeSetId is a required field
	ChangeSetId *string `location:"querystring" locationName:"changeSetId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChangeSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeChangeSetInput"}

	if s.Catalog == nil {
		invalidParams.Add(aws.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Catalog", 1))
	}

	if s.ChangeSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeSetId"))
	}
	if s.ChangeSetId != nil && len(*s.ChangeSetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeChangeSetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Catalog != nil {
		v := *s.Catalog

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "catalog", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChangeSetId != nil {
		v := *s.ChangeSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "changeSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// An array of ChangeSummary objects.
	ChangeSet []ChangeSummary `type:"list"`

	// The ARN associated with the unique identifier for the change set referenced
	// in this request.
	ChangeSetArn *string `min:"1" type:"string"`

	// Required. The unique identifier for the change set referenced in this request.
	ChangeSetId *string `min:"1" type:"string"`

	// The optional name provided in the StartChangeSet request. If you do not provide
	// a name, one is set by default.
	ChangeSetName *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request
	// transitioned to a terminal state. The change cannot transition to a different
	// state. Null if the request is not in a terminal state.
	EndTime *string `min:"20" type:"string"`

	// Returned if there is a failure on the change set, but that failure is not
	// related to any of the changes in the request.
	FailureDescription *string `type:"string"`

	// The date and time, in ISO 8601 format (2018-02-27T13:45:22Z), the request
	// started.
	StartTime *string `min:"20" type:"string"`

	// The status of the change request.
	Status ChangeStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeChangeSetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChangeSet != nil {
		v := s.ChangeSet

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ChangeSet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ChangeSetArn != nil {
		v := *s.ChangeSetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeSetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChangeSetId != nil {
		v := *s.ChangeSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChangeSetName != nil {
		v := *s.ChangeSetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeSetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FailureDescription != nil {
		v := *s.FailureDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FailureDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opDescribeChangeSet = "DescribeChangeSet"

// DescribeChangeSetRequest returns a request value for making API operation for
// AWS Marketplace Catalog Service.
//
// Provides information about a given change set.
//
//    // Example sending a request using DescribeChangeSetRequest.
//    req := client.DescribeChangeSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeChangeSet
func (c *Client) DescribeChangeSetRequest(input *DescribeChangeSetInput) DescribeChangeSetRequest {
	op := &aws.Operation{
		Name:       opDescribeChangeSet,
		HTTPMethod: "GET",
		HTTPPath:   "/DescribeChangeSet",
	}

	if input == nil {
		input = &DescribeChangeSetInput{}
	}

	req := c.newRequest(op, input, &DescribeChangeSetOutput{})

	return DescribeChangeSetRequest{Request: req, Input: input, Copy: c.DescribeChangeSetRequest}
}

// DescribeChangeSetRequest is the request type for the
// DescribeChangeSet API operation.
type DescribeChangeSetRequest struct {
	*aws.Request
	Input *DescribeChangeSetInput
	Copy  func(*DescribeChangeSetInput) DescribeChangeSetRequest
}

// Send marshals and sends the DescribeChangeSet API request.
func (r DescribeChangeSetRequest) Send(ctx context.Context) (*DescribeChangeSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeChangeSetResponse{
		DescribeChangeSetOutput: r.Request.Data.(*DescribeChangeSetOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeChangeSetResponse is the response type for the
// DescribeChangeSet API operation.
type DescribeChangeSetResponse struct {
	*DescribeChangeSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeChangeSet request.
func (r *DescribeChangeSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
