// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediaconnect

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Adds sources to an existing flow.
type AddFlowSourcesInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// A list of sources that you want to add.
	//
	// Sources is a required field
	Sources []SetSourceRequest `locationName:"sources" type:"list" required:"true"`
}

// String returns the string representation
func (s AddFlowSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddFlowSourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddFlowSourcesInput"}

	if s.FlowArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FlowArn"))
	}

	if s.Sources == nil {
		invalidParams.Add(aws.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddFlowSourcesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Sources != nil {
		v := s.Sources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result of a successful AddFlowSources request. The response includes
// the details of the newly added sources.
type AddFlowSourcesOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that these sources were added to.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The details of the newly added sources.
	Sources []Source `locationName:"sources" type:"list"`
}

// String returns the string representation
func (s AddFlowSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddFlowSourcesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sources != nil {
		v := s.Sources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opAddFlowSources = "AddFlowSources"

// AddFlowSourcesRequest returns a request value for making API operation for
// AWS MediaConnect.
//
// Adds Sources to flow
//
//    // Example sending a request using AddFlowSourcesRequest.
//    req := client.AddFlowSourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowSources
func (c *Client) AddFlowSourcesRequest(input *AddFlowSourcesInput) AddFlowSourcesRequest {
	op := &aws.Operation{
		Name:       opAddFlowSources,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/source",
	}

	if input == nil {
		input = &AddFlowSourcesInput{}
	}

	req := c.newRequest(op, input, &AddFlowSourcesOutput{})

	return AddFlowSourcesRequest{Request: req, Input: input, Copy: c.AddFlowSourcesRequest}
}

// AddFlowSourcesRequest is the request type for the
// AddFlowSources API operation.
type AddFlowSourcesRequest struct {
	*aws.Request
	Input *AddFlowSourcesInput
	Copy  func(*AddFlowSourcesInput) AddFlowSourcesRequest
}

// Send marshals and sends the AddFlowSources API request.
func (r AddFlowSourcesRequest) Send(ctx context.Context) (*AddFlowSourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddFlowSourcesResponse{
		AddFlowSourcesOutput: r.Request.Data.(*AddFlowSourcesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddFlowSourcesResponse is the response type for the
// AddFlowSources API operation.
type AddFlowSourcesResponse struct {
	*AddFlowSourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddFlowSources request.
func (r *AddFlowSourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
