// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediaconnect

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Grants an entitlement on a flow.
type GrantFlowEntitlementsInput struct {
	_ struct{} `type:"structure"`

	// The list of entitlements that you want to grant.
	//
	// Entitlements is a required field
	Entitlements []GrantEntitlementRequest `locationName:"entitlements" type:"list" required:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GrantFlowEntitlementsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantFlowEntitlementsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GrantFlowEntitlementsInput"}

	if s.Entitlements == nil {
		invalidParams.Add(aws.NewErrParamRequired("Entitlements"))
	}

	if s.FlowArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FlowArn"))
	}
	if s.Entitlements != nil {
		for i, v := range s.Entitlements {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entitlements", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GrantFlowEntitlementsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Entitlements != nil {
		v := s.Entitlements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "entitlements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The entitlements that were just granted.
type GrantFlowEntitlementsOutput struct {
	_ struct{} `type:"structure"`

	// The entitlements that were just granted.
	Entitlements []Entitlement `locationName:"entitlements" type:"list"`

	// The ARN of the flow that these entitlements were granted to.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s GrantFlowEntitlementsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GrantFlowEntitlementsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Entitlements != nil {
		v := s.Entitlements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "entitlements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGrantFlowEntitlements = "GrantFlowEntitlements"

// GrantFlowEntitlementsRequest returns a request value for making API operation for
// AWS MediaConnect.
//
// Grants entitlements to an existing flow.
//
//    // Example sending a request using GrantFlowEntitlementsRequest.
//    req := client.GrantFlowEntitlementsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements
func (c *Client) GrantFlowEntitlementsRequest(input *GrantFlowEntitlementsInput) GrantFlowEntitlementsRequest {
	op := &aws.Operation{
		Name:       opGrantFlowEntitlements,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/entitlements",
	}

	if input == nil {
		input = &GrantFlowEntitlementsInput{}
	}

	req := c.newRequest(op, input, &GrantFlowEntitlementsOutput{})

	return GrantFlowEntitlementsRequest{Request: req, Input: input, Copy: c.GrantFlowEntitlementsRequest}
}

// GrantFlowEntitlementsRequest is the request type for the
// GrantFlowEntitlements API operation.
type GrantFlowEntitlementsRequest struct {
	*aws.Request
	Input *GrantFlowEntitlementsInput
	Copy  func(*GrantFlowEntitlementsInput) GrantFlowEntitlementsRequest
}

// Send marshals and sends the GrantFlowEntitlements API request.
func (r GrantFlowEntitlementsRequest) Send(ctx context.Context) (*GrantFlowEntitlementsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GrantFlowEntitlementsResponse{
		GrantFlowEntitlementsOutput: r.Request.Data.(*GrantFlowEntitlementsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GrantFlowEntitlementsResponse is the response type for the
// GrantFlowEntitlements API operation.
type GrantFlowEntitlementsResponse struct {
	*GrantFlowEntitlementsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GrantFlowEntitlements request.
func (r *GrantFlowEntitlementsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
