// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediaconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Updates an existing flow.
type UpdateFlowInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The settings for source failover
	SourceFailoverConfig *UpdateFailoverConfig `locationName:"sourceFailoverConfig" type:"structure"`
}

// String returns the string representation
func (s UpdateFlowInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFlowInput"}

	if s.FlowArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FlowArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFlowInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.SourceFailoverConfig != nil {
		v := s.SourceFailoverConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sourceFailoverConfig", v, metadata)
	}
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Updates an existing flow.
type UpdateFlowOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a flow, including its source, outputs, and entitlements.
	Flow *Flow `locationName:"flow" type:"structure"`
}

// String returns the string representation
func (s UpdateFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFlowOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Flow != nil {
		v := s.Flow

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "flow", v, metadata)
	}
	return nil
}

const opUpdateFlow = "UpdateFlow"

// UpdateFlowRequest returns a request value for making API operation for
// AWS MediaConnect.
//
// Updates flow
//
//    // Example sending a request using UpdateFlowRequest.
//    req := client.UpdateFlowRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlow
func (c *Client) UpdateFlowRequest(input *UpdateFlowInput) UpdateFlowRequest {
	op := &aws.Operation{
		Name:       opUpdateFlow,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}",
	}

	if input == nil {
		input = &UpdateFlowInput{}
	}

	req := c.newRequest(op, input, &UpdateFlowOutput{})

	return UpdateFlowRequest{Request: req, Input: input, Copy: c.UpdateFlowRequest}
}

// UpdateFlowRequest is the request type for the
// UpdateFlow API operation.
type UpdateFlowRequest struct {
	*aws.Request
	Input *UpdateFlowInput
	Copy  func(*UpdateFlowInput) UpdateFlowRequest
}

// Send marshals and sends the UpdateFlow API request.
func (r UpdateFlowRequest) Send(ctx context.Context) (*UpdateFlowResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateFlowResponse{
		UpdateFlowOutput: r.Request.Data.(*UpdateFlowOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateFlowResponse is the response type for the
// UpdateFlow API operation.
type UpdateFlowResponse struct {
	*UpdateFlowOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateFlow request.
func (r *UpdateFlowResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
