// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteScheduleInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteScheduleInput"}

	if s.ChannelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteScheduleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChannelId != nil {
		v := *s.ChannelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "channelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteScheduleOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteSchedule = "DeleteSchedule"

// DeleteScheduleRequest returns a request value for making API operation for
// AWS Elemental MediaLive.
//
// Delete all schedule actions on a channel.
//
//    // Example sending a request using DeleteScheduleRequest.
//    req := client.DeleteScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule
func (c *Client) DeleteScheduleRequest(input *DeleteScheduleInput) DeleteScheduleRequest {
	op := &aws.Operation{
		Name:       opDeleteSchedule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/channels/{channelId}/schedule",
	}

	if input == nil {
		input = &DeleteScheduleInput{}
	}

	req := c.newRequest(op, input, &DeleteScheduleOutput{})

	return DeleteScheduleRequest{Request: req, Input: input, Copy: c.DeleteScheduleRequest}
}

// DeleteScheduleRequest is the request type for the
// DeleteSchedule API operation.
type DeleteScheduleRequest struct {
	*aws.Request
	Input *DeleteScheduleInput
	Copy  func(*DeleteScheduleInput) DeleteScheduleRequest
}

// Send marshals and sends the DeleteSchedule API request.
func (r DeleteScheduleRequest) Send(ctx context.Context) (*DeleteScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteScheduleResponse{
		DeleteScheduleOutput: r.Request.Data.(*DeleteScheduleOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteScheduleResponse is the response type for the
// DeleteSchedule API operation.
type DeleteScheduleResponse struct {
	*DeleteScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSchedule request.
func (r *DeleteScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
