// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListInputsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInputsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListInputsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListInputsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListInputsOutput struct {
	_ struct{} `type:"structure"`

	Inputs []Input `locationName:"inputs" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListInputsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Inputs != nil {
		v := s.Inputs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "inputs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListInputs = "ListInputs"

// ListInputsRequest returns a request value for making API operation for
// AWS Elemental MediaLive.
//
// Produces list of inputs that have been created
//
//    // Example sending a request using ListInputsRequest.
//    req := client.ListInputsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs
func (c *Client) ListInputsRequest(input *ListInputsInput) ListInputsRequest {
	op := &aws.Operation{
		Name:       opListInputs,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputs",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputsInput{}
	}

	req := c.newRequest(op, input, &ListInputsOutput{})

	return ListInputsRequest{Request: req, Input: input, Copy: c.ListInputsRequest}
}

// ListInputsRequest is the request type for the
// ListInputs API operation.
type ListInputsRequest struct {
	*aws.Request
	Input *ListInputsInput
	Copy  func(*ListInputsInput) ListInputsRequest
}

// Send marshals and sends the ListInputs API request.
func (r ListInputsRequest) Send(ctx context.Context) (*ListInputsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListInputsResponse{
		ListInputsOutput: r.Request.Data.(*ListInputsOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListInputsRequestPaginator returns a paginator for ListInputs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListInputsRequest(input)
//   p := medialive.NewListInputsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListInputsPaginator(req ListInputsRequest) ListInputsPaginator {
	return ListInputsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListInputsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListInputsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListInputsPaginator struct {
	aws.Pager
}

func (p *ListInputsPaginator) CurrentPage() *ListInputsOutput {
	return p.Pager.CurrentPage().(*ListInputsOutput)
}

// ListInputsResponse is the response type for the
// ListInputs API operation.
type ListInputsResponse struct {
	*ListInputsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListInputs request.
func (r *ListInputsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
