// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediapackagevod

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdatePackagingGroupInput struct {
	_ struct{} `type:"structure"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePackagingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePackagingGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdatePackagingGroupInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Authorization != nil {
		if err := s.Authorization.Validate(); err != nil {
			invalidParams.AddNested("Authorization", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdatePackagingGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Authorization != nil {
		v := s.Authorization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "authorization", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdatePackagingGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	DomainName *string `locationName:"domainName" type:"string"`

	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s UpdatePackagingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdatePackagingGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Authorization != nil {
		v := s.Authorization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "authorization", v, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opUpdatePackagingGroup = "UpdatePackagingGroup"

// UpdatePackagingGroupRequest returns a request value for making API operation for
// AWS Elemental MediaPackage VOD.
//
// Updates a specific packaging group. You can't change the id attribute or
// any other system-generated attributes.
//
//    // Example sending a request using UpdatePackagingGroupRequest.
//    req := client.UpdatePackagingGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/UpdatePackagingGroup
func (c *Client) UpdatePackagingGroupRequest(input *UpdatePackagingGroupInput) UpdatePackagingGroupRequest {
	op := &aws.Operation{
		Name:       opUpdatePackagingGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/packaging_groups/{id}",
	}

	if input == nil {
		input = &UpdatePackagingGroupInput{}
	}

	req := c.newRequest(op, input, &UpdatePackagingGroupOutput{})

	return UpdatePackagingGroupRequest{Request: req, Input: input, Copy: c.UpdatePackagingGroupRequest}
}

// UpdatePackagingGroupRequest is the request type for the
// UpdatePackagingGroup API operation.
type UpdatePackagingGroupRequest struct {
	*aws.Request
	Input *UpdatePackagingGroupInput
	Copy  func(*UpdatePackagingGroupInput) UpdatePackagingGroupRequest
}

// Send marshals and sends the UpdatePackagingGroup API request.
func (r UpdatePackagingGroupRequest) Send(ctx context.Context) (*UpdatePackagingGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdatePackagingGroupResponse{
		UpdatePackagingGroupOutput: r.Request.Data.(*UpdatePackagingGroupOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdatePackagingGroupResponse is the response type for the
// UpdatePackagingGroup API operation.
type UpdatePackagingGroupResponse struct {
	*UpdatePackagingGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdatePackagingGroup request.
func (r *UpdatePackagingGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
