// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediastore

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateContainerInput struct {
	_ struct{} `type:"structure"`

	// The name for the container. The name must be from 1 to 255 characters. Container
	// names must be unique to your AWS account within a specific region. As an
	// example, you could create a container named movies in every region, as long
	// as you don’t have an existing container with that name.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`

	// An array of key:value pairs that you define. These values can be anything
	// that you want. Typically, the tag key represents a category (such as "environment")
	// and the tag value represents a specific value within that category (such
	// as "test," "development," or "production"). You can add up to 50 tags to
	// each container. For more information about tagging, including naming and
	// usage conventions, see Tagging Resources in MediaStore (https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html).
	Tags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateContainerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContainerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateContainerInput"}

	if s.ContainerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContainerName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateContainerOutput struct {
	_ struct{} `type:"structure"`

	// ContainerARN: The Amazon Resource Name (ARN) of the newly created container.
	// The ARN has the following format: arn:aws:<region>:<account that owns this
	// container>:container/<name of container>. For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
	//
	// ContainerName: The container name as specified in the request.
	//
	// CreationTime: Unix time stamp.
	//
	// Status: The status of container creation or deletion. The status is one of
	// the following: CREATING, ACTIVE, or DELETING. While the service is creating
	// the container, the status is CREATING. When an endpoint is available, the
	// status changes to ACTIVE.
	//
	// The return value does not include the container's endpoint. To make downstream
	// requests, you must obtain this value by using DescribeContainer or ListContainers.
	//
	// Container is a required field
	Container *Container `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateContainerOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateContainer = "CreateContainer"

// CreateContainerRequest returns a request value for making API operation for
// AWS Elemental MediaStore.
//
// Creates a storage container to hold objects. A container is similar to a
// bucket in the Amazon S3 service.
//
//    // Example sending a request using CreateContainerRequest.
//    req := client.CreateContainerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/CreateContainer
func (c *Client) CreateContainerRequest(input *CreateContainerInput) CreateContainerRequest {
	op := &aws.Operation{
		Name:       opCreateContainer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContainerInput{}
	}

	req := c.newRequest(op, input, &CreateContainerOutput{})

	return CreateContainerRequest{Request: req, Input: input, Copy: c.CreateContainerRequest}
}

// CreateContainerRequest is the request type for the
// CreateContainer API operation.
type CreateContainerRequest struct {
	*aws.Request
	Input *CreateContainerInput
	Copy  func(*CreateContainerInput) CreateContainerRequest
}

// Send marshals and sends the CreateContainer API request.
func (r CreateContainerRequest) Send(ctx context.Context) (*CreateContainerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateContainerResponse{
		CreateContainerOutput: r.Request.Data.(*CreateContainerOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateContainerResponse is the response type for the
// CreateContainer API operation.
type CreateContainerResponse struct {
	*CreateContainerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateContainer request.
func (r *CreateContainerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
