// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediastore

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteCorsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container to remove the policy from.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCorsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCorsPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCorsPolicyInput"}

	if s.ContainerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteCorsPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCorsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteCorsPolicy = "DeleteCorsPolicy"

// DeleteCorsPolicyRequest returns a request value for making API operation for
// AWS Elemental MediaStore.
//
// Deletes the cross-origin resource sharing (CORS) configuration information
// that is set for the container.
//
// To use this operation, you must have permission to perform the MediaStore:DeleteCorsPolicy
// action. The container owner has this permission by default and can grant
// this permission to others.
//
//    // Example sending a request using DeleteCorsPolicyRequest.
//    req := client.DeleteCorsPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteCorsPolicy
func (c *Client) DeleteCorsPolicyRequest(input *DeleteCorsPolicyInput) DeleteCorsPolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteCorsPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCorsPolicyInput{}
	}

	req := c.newRequest(op, input, &DeleteCorsPolicyOutput{})

	return DeleteCorsPolicyRequest{Request: req, Input: input, Copy: c.DeleteCorsPolicyRequest}
}

// DeleteCorsPolicyRequest is the request type for the
// DeleteCorsPolicy API operation.
type DeleteCorsPolicyRequest struct {
	*aws.Request
	Input *DeleteCorsPolicyInput
	Copy  func(*DeleteCorsPolicyInput) DeleteCorsPolicyRequest
}

// Send marshals and sends the DeleteCorsPolicy API request.
func (r DeleteCorsPolicyRequest) Send(ctx context.Context) (*DeleteCorsPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCorsPolicyResponse{
		DeleteCorsPolicyOutput: r.Request.Data.(*DeleteCorsPolicyOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCorsPolicyResponse is the response type for the
// DeleteCorsPolicy API operation.
type DeleteCorsPolicyResponse struct {
	*DeleteCorsPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCorsPolicy request.
func (r *DeleteCorsPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
