// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediastore

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListContainersInput struct {
	_ struct{} `type:"structure"`

	// Enter the maximum number of containers in the response. Use from 1 to 255
	// characters.
	MaxResults *int64 `min:"1" type:"integer"`

	// Only if you used MaxResults in the first command, enter the token (which
	// was included in the previous response) to obtain the next set of containers.
	// This token is included in a response only if there actually are more containers
	// to list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListContainersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContainersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListContainersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListContainersOutput struct {
	_ struct{} `type:"structure"`

	// The names of the containers.
	//
	// Containers is a required field
	Containers []Container `type:"list" required:"true"`

	// NextToken is the token to use in the next call to ListContainers. This token
	// is returned only if you included the MaxResults tag in the original command,
	// and only if there are still containers to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListContainersOutput) String() string {
	return awsutil.Prettify(s)
}

const opListContainers = "ListContainers"

// ListContainersRequest returns a request value for making API operation for
// AWS Elemental MediaStore.
//
// Lists the properties of all containers in AWS Elemental MediaStore.
//
// You can query to receive all the containers in one response. Or you can include
// the MaxResults parameter to receive a limited number of containers in each
// response. In this case, the response includes a token. To get the next set
// of containers, send the command again, this time with the NextToken parameter
// (with the returned token as its value). The next set of responses appears,
// with a token if there are still more containers to receive.
//
// See also DescribeContainer, which gets the properties of one container.
//
//    // Example sending a request using ListContainersRequest.
//    req := client.ListContainersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainers
func (c *Client) ListContainersRequest(input *ListContainersInput) ListContainersRequest {
	op := &aws.Operation{
		Name:       opListContainers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContainersInput{}
	}

	req := c.newRequest(op, input, &ListContainersOutput{})

	return ListContainersRequest{Request: req, Input: input, Copy: c.ListContainersRequest}
}

// ListContainersRequest is the request type for the
// ListContainers API operation.
type ListContainersRequest struct {
	*aws.Request
	Input *ListContainersInput
	Copy  func(*ListContainersInput) ListContainersRequest
}

// Send marshals and sends the ListContainers API request.
func (r ListContainersRequest) Send(ctx context.Context) (*ListContainersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListContainersResponse{
		ListContainersOutput: r.Request.Data.(*ListContainersOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListContainersRequestPaginator returns a paginator for ListContainers.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListContainersRequest(input)
//   p := mediastore.NewListContainersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListContainersPaginator(req ListContainersRequest) ListContainersPaginator {
	return ListContainersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListContainersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListContainersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListContainersPaginator struct {
	aws.Pager
}

func (p *ListContainersPaginator) CurrentPage() *ListContainersOutput {
	return p.Pager.CurrentPage().(*ListContainersOutput)
}

// ListContainersResponse is the response type for the
// ListContainers API operation.
type ListContainersResponse struct {
	*ListContainersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListContainers request.
func (r *ListContainersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
