// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediatailor

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeletePlaybackConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Name is a required field
	Name *string `location:"uri" locationName:"Name" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePlaybackConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePlaybackConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePlaybackConfigurationInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePlaybackConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeletePlaybackConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePlaybackConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePlaybackConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeletePlaybackConfiguration = "DeletePlaybackConfiguration"

// DeletePlaybackConfigurationRequest returns a request value for making API operation for
// AWS MediaTailor.
//
// Deletes the playback configuration for the specified name.
//
//    // Example sending a request using DeletePlaybackConfigurationRequest.
//    req := client.DeletePlaybackConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/DeletePlaybackConfiguration
func (c *Client) DeletePlaybackConfigurationRequest(input *DeletePlaybackConfigurationInput) DeletePlaybackConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeletePlaybackConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/playbackConfiguration/{Name}",
	}

	if input == nil {
		input = &DeletePlaybackConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeletePlaybackConfigurationOutput{})

	return DeletePlaybackConfigurationRequest{Request: req, Input: input, Copy: c.DeletePlaybackConfigurationRequest}
}

// DeletePlaybackConfigurationRequest is the request type for the
// DeletePlaybackConfiguration API operation.
type DeletePlaybackConfigurationRequest struct {
	*aws.Request
	Input *DeletePlaybackConfigurationInput
	Copy  func(*DeletePlaybackConfigurationInput) DeletePlaybackConfigurationRequest
}

// Send marshals and sends the DeletePlaybackConfiguration API request.
func (r DeletePlaybackConfigurationRequest) Send(ctx context.Context) (*DeletePlaybackConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePlaybackConfigurationResponse{
		DeletePlaybackConfigurationOutput: r.Request.Data.(*DeletePlaybackConfigurationOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePlaybackConfigurationResponse is the response type for the
// DeletePlaybackConfiguration API operation.
type DeletePlaybackConfigurationResponse struct {
	*DeletePlaybackConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePlaybackConfiguration request.
func (r *DeletePlaybackConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
