// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package migrationhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListCreatedArtifactsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to be returned per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// Unique identifier that references the migration task. Do not store personal
	// data in this field.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// If a NextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in NextToken.
	NextToken *string `type:"string"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListCreatedArtifactsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCreatedArtifactsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListCreatedArtifactsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.MigrationTaskName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MigrationTaskName", 1))
	}

	if s.ProgressUpdateStream == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProgressUpdateStream", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListCreatedArtifactsOutput struct {
	_ struct{} `type:"structure"`

	// List of created artifacts up to the maximum number of results specified in
	// the request.
	CreatedArtifactList []CreatedArtifact `type:"list"`

	// If there are more created artifacts than the max result, return the next
	// token to be passed to the next call as a bookmark of where to start from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCreatedArtifactsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListCreatedArtifacts = "ListCreatedArtifacts"

// ListCreatedArtifactsRequest returns a request value for making API operation for
// AWS Migration Hub.
//
// Lists the created artifacts attached to a given migration task in an update
// stream. This API has the following traits:
//
//    * Gets the list of the created artifacts while migration is taking place.
//
//    * Shows the artifacts created by the migration tool that was associated
//    by the AssociateCreatedArtifact API.
//
//    * Lists created artifacts in a paginated interface.
//
//    // Example sending a request using ListCreatedArtifactsRequest.
//    req := client.ListCreatedArtifactsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListCreatedArtifacts
func (c *Client) ListCreatedArtifactsRequest(input *ListCreatedArtifactsInput) ListCreatedArtifactsRequest {
	op := &aws.Operation{
		Name:       opListCreatedArtifacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCreatedArtifactsInput{}
	}

	req := c.newRequest(op, input, &ListCreatedArtifactsOutput{})

	return ListCreatedArtifactsRequest{Request: req, Input: input, Copy: c.ListCreatedArtifactsRequest}
}

// ListCreatedArtifactsRequest is the request type for the
// ListCreatedArtifacts API operation.
type ListCreatedArtifactsRequest struct {
	*aws.Request
	Input *ListCreatedArtifactsInput
	Copy  func(*ListCreatedArtifactsInput) ListCreatedArtifactsRequest
}

// Send marshals and sends the ListCreatedArtifacts API request.
func (r ListCreatedArtifactsRequest) Send(ctx context.Context) (*ListCreatedArtifactsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListCreatedArtifactsResponse{
		ListCreatedArtifactsOutput: r.Request.Data.(*ListCreatedArtifactsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListCreatedArtifactsRequestPaginator returns a paginator for ListCreatedArtifacts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListCreatedArtifactsRequest(input)
//   p := migrationhub.NewListCreatedArtifactsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListCreatedArtifactsPaginator(req ListCreatedArtifactsRequest) ListCreatedArtifactsPaginator {
	return ListCreatedArtifactsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListCreatedArtifactsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListCreatedArtifactsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListCreatedArtifactsPaginator struct {
	aws.Pager
}

func (p *ListCreatedArtifactsPaginator) CurrentPage() *ListCreatedArtifactsOutput {
	return p.Pager.CurrentPage().(*ListCreatedArtifactsOutput)
}

// ListCreatedArtifactsResponse is the response type for the
// ListCreatedArtifacts API operation.
type ListCreatedArtifactsResponse struct {
	*ListCreatedArtifactsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListCreatedArtifacts request.
func (r *ListCreatedArtifactsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
