// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package migrationhubconfig

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateHomeRegionControlInput struct {
	_ struct{} `type:"structure"`

	// Optional Boolean flag to indicate whether any effect should take place. It
	// tests whether the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// The name of the home region of the calling account.
	//
	// HomeRegion is a required field
	HomeRegion *string `min:"1" type:"string" required:"true"`

	// The account for which this command sets up a home region control. The Target
	// is always of type ACCOUNT.
	//
	// Target is a required field
	Target *Target `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateHomeRegionControlInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHomeRegionControlInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateHomeRegionControlInput"}

	if s.HomeRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("HomeRegion"))
	}
	if s.HomeRegion != nil && len(*s.HomeRegion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HomeRegion", 1))
	}

	if s.Target == nil {
		invalidParams.Add(aws.NewErrParamRequired("Target"))
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateHomeRegionControlOutput struct {
	_ struct{} `type:"structure"`

	// This object is the HomeRegionControl object that's returned by a successful
	// call to CreateHomeRegionControl.
	HomeRegionControl *HomeRegionControl `type:"structure"`
}

// String returns the string representation
func (s CreateHomeRegionControlOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateHomeRegionControl = "CreateHomeRegionControl"

// CreateHomeRegionControlRequest returns a request value for making API operation for
// AWS Migration Hub Config.
//
// This API sets up the home region for the calling account only.
//
//    // Example sending a request using CreateHomeRegionControlRequest.
//    req := client.CreateHomeRegionControlRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/CreateHomeRegionControl
func (c *Client) CreateHomeRegionControlRequest(input *CreateHomeRegionControlInput) CreateHomeRegionControlRequest {
	op := &aws.Operation{
		Name:       opCreateHomeRegionControl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHomeRegionControlInput{}
	}

	req := c.newRequest(op, input, &CreateHomeRegionControlOutput{})

	return CreateHomeRegionControlRequest{Request: req, Input: input, Copy: c.CreateHomeRegionControlRequest}
}

// CreateHomeRegionControlRequest is the request type for the
// CreateHomeRegionControl API operation.
type CreateHomeRegionControlRequest struct {
	*aws.Request
	Input *CreateHomeRegionControlInput
	Copy  func(*CreateHomeRegionControlInput) CreateHomeRegionControlRequest
}

// Send marshals and sends the CreateHomeRegionControl API request.
func (r CreateHomeRegionControlRequest) Send(ctx context.Context) (*CreateHomeRegionControlResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateHomeRegionControlResponse{
		CreateHomeRegionControlOutput: r.Request.Data.(*CreateHomeRegionControlOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateHomeRegionControlResponse is the response type for the
// CreateHomeRegionControl API operation.
type CreateHomeRegionControlResponse struct {
	*CreateHomeRegionControlOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateHomeRegionControl request.
func (r *CreateHomeRegionControlResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
