// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package migrationhubconfig

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeHomeRegionControlsInput struct {
	_ struct{} `type:"structure"`

	// The ControlID is a unique identifier string of your HomeRegionControl object.
	ControlId *string `min:"1" type:"string"`

	// The name of the home region you'd like to view.
	HomeRegion *string `min:"1" type:"string"`

	// The maximum number of filtering results to display per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// If a NextToken was returned by a previous call, more results are available.
	// To retrieve the next page of results, make the call again using the returned
	// token in NextToken.
	NextToken *string `type:"string"`

	// The target parameter specifies the identifier to which the home region is
	// applied, which is always of type ACCOUNT. It applies the home region to the
	// current ACCOUNT.
	Target *Target `type:"structure"`
}

// String returns the string representation
func (s DescribeHomeRegionControlsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHomeRegionControlsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeHomeRegionControlsInput"}
	if s.ControlId != nil && len(*s.ControlId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ControlId", 1))
	}
	if s.HomeRegion != nil && len(*s.HomeRegion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HomeRegion", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeHomeRegionControlsOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains your HomeRegionControl objects.
	HomeRegionControls []HomeRegionControl `type:"list"`

	// If a NextToken was returned by a previous call, more results are available.
	// To retrieve the next page of results, make the call again using the returned
	// token in NextToken.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeHomeRegionControlsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeHomeRegionControls = "DescribeHomeRegionControls"

// DescribeHomeRegionControlsRequest returns a request value for making API operation for
// AWS Migration Hub Config.
//
// This API permits filtering on the ControlId and HomeRegion fields.
//
//    // Example sending a request using DescribeHomeRegionControlsRequest.
//    req := client.DescribeHomeRegionControlsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/migrationhub-config-2019-06-30/DescribeHomeRegionControls
func (c *Client) DescribeHomeRegionControlsRequest(input *DescribeHomeRegionControlsInput) DescribeHomeRegionControlsRequest {
	op := &aws.Operation{
		Name:       opDescribeHomeRegionControls,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHomeRegionControlsInput{}
	}

	req := c.newRequest(op, input, &DescribeHomeRegionControlsOutput{})

	return DescribeHomeRegionControlsRequest{Request: req, Input: input, Copy: c.DescribeHomeRegionControlsRequest}
}

// DescribeHomeRegionControlsRequest is the request type for the
// DescribeHomeRegionControls API operation.
type DescribeHomeRegionControlsRequest struct {
	*aws.Request
	Input *DescribeHomeRegionControlsInput
	Copy  func(*DescribeHomeRegionControlsInput) DescribeHomeRegionControlsRequest
}

// Send marshals and sends the DescribeHomeRegionControls API request.
func (r DescribeHomeRegionControlsRequest) Send(ctx context.Context) (*DescribeHomeRegionControlsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeHomeRegionControlsResponse{
		DescribeHomeRegionControlsOutput: r.Request.Data.(*DescribeHomeRegionControlsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeHomeRegionControlsRequestPaginator returns a paginator for DescribeHomeRegionControls.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeHomeRegionControlsRequest(input)
//   p := migrationhubconfig.NewDescribeHomeRegionControlsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeHomeRegionControlsPaginator(req DescribeHomeRegionControlsRequest) DescribeHomeRegionControlsPaginator {
	return DescribeHomeRegionControlsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeHomeRegionControlsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeHomeRegionControlsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeHomeRegionControlsPaginator struct {
	aws.Pager
}

func (p *DescribeHomeRegionControlsPaginator) CurrentPage() *DescribeHomeRegionControlsOutput {
	return p.Pager.CurrentPage().(*DescribeHomeRegionControlsOutput)
}

// DescribeHomeRegionControlsResponse is the response type for the
// DescribeHomeRegionControls API operation.
type DescribeHomeRegionControlsResponse struct {
	*DescribeHomeRegionControlsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeHomeRegionControls request.
func (r *DescribeHomeRegionControlsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
