// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mobile

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request structure to request all available bundles.
type ListBundlesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of records to list in a single response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Pagination token. Set to null to start listing bundles from start. If non-null
	// pagination token is returned in a result, then pass its value in here in
	// another request to list more bundles.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBundlesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Result structure contains a list of all available bundles with details.
type ListBundlesOutput struct {
	_ struct{} `type:"structure"`

	// A list of bundles.
	BundleList []BundleDetails `locationName:"bundleList" type:"list"`

	// Pagination token. If non-null pagination token is returned in a result, then
	// pass its value in another request to fetch more entries.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBundlesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BundleList != nil {
		v := s.BundleList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "bundleList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListBundles = "ListBundles"

// ListBundlesRequest returns a request value for making API operation for
// AWS Mobile.
//
// List all available bundles.
//
//    // Example sending a request using ListBundlesRequest.
//    req := client.ListBundlesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles
func (c *Client) ListBundlesRequest(input *ListBundlesInput) ListBundlesRequest {
	op := &aws.Operation{
		Name:       opListBundles,
		HTTPMethod: "GET",
		HTTPPath:   "/bundles",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBundlesInput{}
	}

	req := c.newRequest(op, input, &ListBundlesOutput{})

	return ListBundlesRequest{Request: req, Input: input, Copy: c.ListBundlesRequest}
}

// ListBundlesRequest is the request type for the
// ListBundles API operation.
type ListBundlesRequest struct {
	*aws.Request
	Input *ListBundlesInput
	Copy  func(*ListBundlesInput) ListBundlesRequest
}

// Send marshals and sends the ListBundles API request.
func (r ListBundlesRequest) Send(ctx context.Context) (*ListBundlesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBundlesResponse{
		ListBundlesOutput: r.Request.Data.(*ListBundlesOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListBundlesRequestPaginator returns a paginator for ListBundles.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListBundlesRequest(input)
//   p := mobile.NewListBundlesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListBundlesPaginator(req ListBundlesRequest) ListBundlesPaginator {
	return ListBundlesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListBundlesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListBundlesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListBundlesPaginator struct {
	aws.Pager
}

func (p *ListBundlesPaginator) CurrentPage() *ListBundlesOutput {
	return p.Pager.CurrentPage().(*ListBundlesOutput)
}

// ListBundlesResponse is the response type for the
// ListBundles API operation.
type ListBundlesResponse struct {
	*ListBundlesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBundles request.
func (r *ListBundlesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
