// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mq

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The type of broker engine. Note: Currently, Amazon MQ supports only ActiveMQ.
	EngineType EngineType `locationName:"engineType" type:"string" enum:"true"`

	EngineVersion *string `locationName:"engineVersion" type:"string"`

	Name *string `locationName:"name" type:"string"`

	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.EngineType) > 0 {
		v := s.EngineType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "engineType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EngineVersion != nil {
		v := *s.EngineVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "engineVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"iso8601"`

	Id *string `locationName:"id" type:"string"`

	// Returns information about the specified configuration revision.
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s CreateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Created != nil {
		v := *s.Created

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "created",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LatestRevision != nil {
		v := s.LatestRevision

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "latestRevision", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateConfiguration = "CreateConfiguration"

// CreateConfigurationRequest returns a request value for making API operation for
// AmazonMQ.
//
// Creates a new configuration for the specified configuration name. Amazon
// MQ uses the default configuration (the engine type and version).
//
//    // Example sending a request using CreateConfigurationRequest.
//    req := client.CreateConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateConfiguration
func (c *Client) CreateConfigurationRequest(input *CreateConfigurationInput) CreateConfigurationRequest {
	op := &aws.Operation{
		Name:       opCreateConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/configurations",
	}

	if input == nil {
		input = &CreateConfigurationInput{}
	}

	req := c.newRequest(op, input, &CreateConfigurationOutput{})

	return CreateConfigurationRequest{Request: req, Input: input, Copy: c.CreateConfigurationRequest}
}

// CreateConfigurationRequest is the request type for the
// CreateConfiguration API operation.
type CreateConfigurationRequest struct {
	*aws.Request
	Input *CreateConfigurationInput
	Copy  func(*CreateConfigurationInput) CreateConfigurationRequest
}

// Send marshals and sends the CreateConfiguration API request.
func (r CreateConfigurationRequest) Send(ctx context.Context) (*CreateConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateConfigurationResponse{
		CreateConfigurationOutput: r.Request.Data.(*CreateConfigurationOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateConfigurationResponse is the response type for the
// CreateConfiguration API operation.
type CreateConfigurationResponse struct {
	*CreateConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateConfiguration request.
func (r *CreateConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
