// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mq

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListBrokersInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBrokersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBrokersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBrokersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBrokersInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListBrokersOutput struct {
	_ struct{} `type:"structure"`

	BrokerSummaries []BrokerSummary `locationName:"brokerSummaries" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBrokersOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBrokersOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BrokerSummaries != nil {
		v := s.BrokerSummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "brokerSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListBrokers = "ListBrokers"

// ListBrokersRequest returns a request value for making API operation for
// AmazonMQ.
//
// Returns a list of all brokers.
//
//    // Example sending a request using ListBrokersRequest.
//    req := client.ListBrokersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers
func (c *Client) ListBrokersRequest(input *ListBrokersInput) ListBrokersRequest {
	op := &aws.Operation{
		Name:       opListBrokers,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/brokers",
	}

	if input == nil {
		input = &ListBrokersInput{}
	}

	req := c.newRequest(op, input, &ListBrokersOutput{})

	return ListBrokersRequest{Request: req, Input: input, Copy: c.ListBrokersRequest}
}

// ListBrokersRequest is the request type for the
// ListBrokers API operation.
type ListBrokersRequest struct {
	*aws.Request
	Input *ListBrokersInput
	Copy  func(*ListBrokersInput) ListBrokersRequest
}

// Send marshals and sends the ListBrokers API request.
func (r ListBrokersRequest) Send(ctx context.Context) (*ListBrokersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBrokersResponse{
		ListBrokersOutput: r.Request.Data.(*ListBrokersOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListBrokersResponse is the response type for the
// ListBrokers API operation.
type ListBrokersResponse struct {
	*ListBrokersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBrokers request.
func (r *ListBrokersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
