// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package neptuneiface provides an interface to enable mocking the Amazon Neptune service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package neptuneiface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/neptune"
)

// ClientAPI provides an interface to enable mocking the
// neptune.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Neptune.
//    func myFunc(svc neptuneiface.ClientAPI) bool {
//        // Make svc.AddRoleToDBCluster request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := neptune.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        neptuneiface.ClientPI
//    }
//    func (m *mockClientClient) AddRoleToDBCluster(input *neptune.AddRoleToDBClusterInput) (*neptune.AddRoleToDBClusterOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AddRoleToDBClusterRequest(*neptune.AddRoleToDBClusterInput) neptune.AddRoleToDBClusterRequest

	AddSourceIdentifierToSubscriptionRequest(*neptune.AddSourceIdentifierToSubscriptionInput) neptune.AddSourceIdentifierToSubscriptionRequest

	AddTagsToResourceRequest(*neptune.AddTagsToResourceInput) neptune.AddTagsToResourceRequest

	ApplyPendingMaintenanceActionRequest(*neptune.ApplyPendingMaintenanceActionInput) neptune.ApplyPendingMaintenanceActionRequest

	CopyDBClusterParameterGroupRequest(*neptune.CopyDBClusterParameterGroupInput) neptune.CopyDBClusterParameterGroupRequest

	CopyDBClusterSnapshotRequest(*neptune.CopyDBClusterSnapshotInput) neptune.CopyDBClusterSnapshotRequest

	CopyDBParameterGroupRequest(*neptune.CopyDBParameterGroupInput) neptune.CopyDBParameterGroupRequest

	CreateDBClusterRequest(*neptune.CreateDBClusterInput) neptune.CreateDBClusterRequest

	CreateDBClusterParameterGroupRequest(*neptune.CreateDBClusterParameterGroupInput) neptune.CreateDBClusterParameterGroupRequest

	CreateDBClusterSnapshotRequest(*neptune.CreateDBClusterSnapshotInput) neptune.CreateDBClusterSnapshotRequest

	CreateDBInstanceRequest(*neptune.CreateDBInstanceInput) neptune.CreateDBInstanceRequest

	CreateDBParameterGroupRequest(*neptune.CreateDBParameterGroupInput) neptune.CreateDBParameterGroupRequest

	CreateDBSubnetGroupRequest(*neptune.CreateDBSubnetGroupInput) neptune.CreateDBSubnetGroupRequest

	CreateEventSubscriptionRequest(*neptune.CreateEventSubscriptionInput) neptune.CreateEventSubscriptionRequest

	DeleteDBClusterRequest(*neptune.DeleteDBClusterInput) neptune.DeleteDBClusterRequest

	DeleteDBClusterParameterGroupRequest(*neptune.DeleteDBClusterParameterGroupInput) neptune.DeleteDBClusterParameterGroupRequest

	DeleteDBClusterSnapshotRequest(*neptune.DeleteDBClusterSnapshotInput) neptune.DeleteDBClusterSnapshotRequest

	DeleteDBInstanceRequest(*neptune.DeleteDBInstanceInput) neptune.DeleteDBInstanceRequest

	DeleteDBParameterGroupRequest(*neptune.DeleteDBParameterGroupInput) neptune.DeleteDBParameterGroupRequest

	DeleteDBSubnetGroupRequest(*neptune.DeleteDBSubnetGroupInput) neptune.DeleteDBSubnetGroupRequest

	DeleteEventSubscriptionRequest(*neptune.DeleteEventSubscriptionInput) neptune.DeleteEventSubscriptionRequest

	DescribeDBClusterParameterGroupsRequest(*neptune.DescribeDBClusterParameterGroupsInput) neptune.DescribeDBClusterParameterGroupsRequest

	DescribeDBClusterParametersRequest(*neptune.DescribeDBClusterParametersInput) neptune.DescribeDBClusterParametersRequest

	DescribeDBClusterSnapshotAttributesRequest(*neptune.DescribeDBClusterSnapshotAttributesInput) neptune.DescribeDBClusterSnapshotAttributesRequest

	DescribeDBClusterSnapshotsRequest(*neptune.DescribeDBClusterSnapshotsInput) neptune.DescribeDBClusterSnapshotsRequest

	DescribeDBClustersRequest(*neptune.DescribeDBClustersInput) neptune.DescribeDBClustersRequest

	DescribeDBEngineVersionsRequest(*neptune.DescribeDBEngineVersionsInput) neptune.DescribeDBEngineVersionsRequest

	DescribeDBInstancesRequest(*neptune.DescribeDBInstancesInput) neptune.DescribeDBInstancesRequest

	DescribeDBParameterGroupsRequest(*neptune.DescribeDBParameterGroupsInput) neptune.DescribeDBParameterGroupsRequest

	DescribeDBParametersRequest(*neptune.DescribeDBParametersInput) neptune.DescribeDBParametersRequest

	DescribeDBSubnetGroupsRequest(*neptune.DescribeDBSubnetGroupsInput) neptune.DescribeDBSubnetGroupsRequest

	DescribeEngineDefaultClusterParametersRequest(*neptune.DescribeEngineDefaultClusterParametersInput) neptune.DescribeEngineDefaultClusterParametersRequest

	DescribeEngineDefaultParametersRequest(*neptune.DescribeEngineDefaultParametersInput) neptune.DescribeEngineDefaultParametersRequest

	DescribeEventCategoriesRequest(*neptune.DescribeEventCategoriesInput) neptune.DescribeEventCategoriesRequest

	DescribeEventSubscriptionsRequest(*neptune.DescribeEventSubscriptionsInput) neptune.DescribeEventSubscriptionsRequest

	DescribeEventsRequest(*neptune.DescribeEventsInput) neptune.DescribeEventsRequest

	DescribeOrderableDBInstanceOptionsRequest(*neptune.DescribeOrderableDBInstanceOptionsInput) neptune.DescribeOrderableDBInstanceOptionsRequest

	DescribePendingMaintenanceActionsRequest(*neptune.DescribePendingMaintenanceActionsInput) neptune.DescribePendingMaintenanceActionsRequest

	DescribeValidDBInstanceModificationsRequest(*neptune.DescribeValidDBInstanceModificationsInput) neptune.DescribeValidDBInstanceModificationsRequest

	FailoverDBClusterRequest(*neptune.FailoverDBClusterInput) neptune.FailoverDBClusterRequest

	ListTagsForResourceRequest(*neptune.ListTagsForResourceInput) neptune.ListTagsForResourceRequest

	ModifyDBClusterRequest(*neptune.ModifyDBClusterInput) neptune.ModifyDBClusterRequest

	ModifyDBClusterParameterGroupRequest(*neptune.ModifyDBClusterParameterGroupInput) neptune.ModifyDBClusterParameterGroupRequest

	ModifyDBClusterSnapshotAttributeRequest(*neptune.ModifyDBClusterSnapshotAttributeInput) neptune.ModifyDBClusterSnapshotAttributeRequest

	ModifyDBInstanceRequest(*neptune.ModifyDBInstanceInput) neptune.ModifyDBInstanceRequest

	ModifyDBParameterGroupRequest(*neptune.ModifyDBParameterGroupInput) neptune.ModifyDBParameterGroupRequest

	ModifyDBSubnetGroupRequest(*neptune.ModifyDBSubnetGroupInput) neptune.ModifyDBSubnetGroupRequest

	ModifyEventSubscriptionRequest(*neptune.ModifyEventSubscriptionInput) neptune.ModifyEventSubscriptionRequest

	PromoteReadReplicaDBClusterRequest(*neptune.PromoteReadReplicaDBClusterInput) neptune.PromoteReadReplicaDBClusterRequest

	RebootDBInstanceRequest(*neptune.RebootDBInstanceInput) neptune.RebootDBInstanceRequest

	RemoveRoleFromDBClusterRequest(*neptune.RemoveRoleFromDBClusterInput) neptune.RemoveRoleFromDBClusterRequest

	RemoveSourceIdentifierFromSubscriptionRequest(*neptune.RemoveSourceIdentifierFromSubscriptionInput) neptune.RemoveSourceIdentifierFromSubscriptionRequest

	RemoveTagsFromResourceRequest(*neptune.RemoveTagsFromResourceInput) neptune.RemoveTagsFromResourceRequest

	ResetDBClusterParameterGroupRequest(*neptune.ResetDBClusterParameterGroupInput) neptune.ResetDBClusterParameterGroupRequest

	ResetDBParameterGroupRequest(*neptune.ResetDBParameterGroupInput) neptune.ResetDBParameterGroupRequest

	RestoreDBClusterFromSnapshotRequest(*neptune.RestoreDBClusterFromSnapshotInput) neptune.RestoreDBClusterFromSnapshotRequest

	RestoreDBClusterToPointInTimeRequest(*neptune.RestoreDBClusterToPointInTimeInput) neptune.RestoreDBClusterToPointInTimeRequest

	StartDBClusterRequest(*neptune.StartDBClusterInput) neptune.StartDBClusterRequest

	StopDBClusterRequest(*neptune.StopDBClusterInput) neptune.StopDBClusterRequest

	WaitUntilDBInstanceAvailable(context.Context, *neptune.DescribeDBInstancesInput, ...aws.WaiterOption) error

	WaitUntilDBInstanceDeleted(context.Context, *neptune.DescribeDBInstancesInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*neptune.Client)(nil)
