// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteSiteInput struct {
	_ struct{} `type:"structure"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The ID of the site.
	//
	// SiteId is a required field
	SiteId *string `location:"uri" locationName:"siteId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSiteInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSiteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSiteInput"}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if s.SiteId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SiteId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSiteInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SiteId != nil {
		v := *s.SiteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "siteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteSiteOutput struct {
	_ struct{} `type:"structure"`

	// Information about the site.
	Site *Site `type:"structure"`
}

// String returns the string representation
func (s DeleteSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSiteOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Site != nil {
		v := s.Site

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Site", v, metadata)
	}
	return nil
}

const opDeleteSite = "DeleteSite"

// DeleteSiteRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Deletes an existing site. The site cannot be associated with any device or
// link.
//
//    // Example sending a request using DeleteSiteRequest.
//    req := client.DeleteSiteRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DeleteSite
func (c *Client) DeleteSiteRequest(input *DeleteSiteInput) DeleteSiteRequest {
	op := &aws.Operation{
		Name:       opDeleteSite,
		HTTPMethod: "DELETE",
		HTTPPath:   "/global-networks/{globalNetworkId}/sites/{siteId}",
	}

	if input == nil {
		input = &DeleteSiteInput{}
	}

	req := c.newRequest(op, input, &DeleteSiteOutput{})

	return DeleteSiteRequest{Request: req, Input: input, Copy: c.DeleteSiteRequest}
}

// DeleteSiteRequest is the request type for the
// DeleteSite API operation.
type DeleteSiteRequest struct {
	*aws.Request
	Input *DeleteSiteInput
	Copy  func(*DeleteSiteInput) DeleteSiteRequest
}

// Send marshals and sends the DeleteSite API request.
func (r DeleteSiteRequest) Send(ctx context.Context) (*DeleteSiteResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSiteResponse{
		DeleteSiteOutput: r.Request.Data.(*DeleteSiteOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSiteResponse is the response type for the
// DeleteSite API operation.
type DeleteSiteResponse struct {
	*DeleteSiteOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSite request.
func (r *DeleteSiteResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
