// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DisassociateLinkInput struct {
	_ struct{} `type:"structure"`

	// The ID of the device.
	//
	// DeviceId is a required field
	DeviceId *string `location:"querystring" locationName:"deviceId" type:"string" required:"true"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The ID of the link.
	//
	// LinkId is a required field
	LinkId *string `location:"querystring" locationName:"linkId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateLinkInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateLinkInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateLinkInput"}

	if s.DeviceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceId"))
	}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if s.LinkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LinkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateLinkInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "deviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LinkId != nil {
		v := *s.LinkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "linkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DisassociateLinkOutput struct {
	_ struct{} `type:"structure"`

	// Information about the link association.
	LinkAssociation *LinkAssociation `type:"structure"`
}

// String returns the string representation
func (s DisassociateLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateLinkOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.LinkAssociation != nil {
		v := s.LinkAssociation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LinkAssociation", v, metadata)
	}
	return nil
}

const opDisassociateLink = "DisassociateLink"

// DisassociateLinkRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Disassociates an existing device from a link. You must first disassociate
// any customer gateways that are associated with the link.
//
//    // Example sending a request using DisassociateLinkRequest.
//    req := client.DisassociateLinkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/DisassociateLink
func (c *Client) DisassociateLinkRequest(input *DisassociateLinkInput) DisassociateLinkRequest {
	op := &aws.Operation{
		Name:       opDisassociateLink,
		HTTPMethod: "DELETE",
		HTTPPath:   "/global-networks/{globalNetworkId}/link-associations",
	}

	if input == nil {
		input = &DisassociateLinkInput{}
	}

	req := c.newRequest(op, input, &DisassociateLinkOutput{})

	return DisassociateLinkRequest{Request: req, Input: input, Copy: c.DisassociateLinkRequest}
}

// DisassociateLinkRequest is the request type for the
// DisassociateLink API operation.
type DisassociateLinkRequest struct {
	*aws.Request
	Input *DisassociateLinkInput
	Copy  func(*DisassociateLinkInput) DisassociateLinkRequest
}

// Send marshals and sends the DisassociateLink API request.
func (r DisassociateLinkRequest) Send(ctx context.Context) (*DisassociateLinkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateLinkResponse{
		DisassociateLinkOutput: r.Request.Data.(*DisassociateLinkOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateLinkResponse is the response type for the
// DisassociateLink API operation.
type DisassociateLinkResponse struct {
	*DisassociateLinkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateLink request.
func (r *DisassociateLinkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
