// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetLinkAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the device.
	DeviceId *string `location:"querystring" locationName:"deviceId" type:"string"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The ID of the link.
	LinkId *string `location:"querystring" locationName:"linkId" type:"string"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetLinkAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLinkAssociationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetLinkAssociationsInput"}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetLinkAssociationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "deviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LinkId != nil {
		v := *s.LinkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "linkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetLinkAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The link associations.
	LinkAssociations []LinkAssociation `type:"list"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetLinkAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetLinkAssociationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.LinkAssociations != nil {
		v := s.LinkAssociations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "LinkAssociations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetLinkAssociations = "GetLinkAssociations"

// GetLinkAssociationsRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Gets the link associations for a device or a link. Either the device ID or
// the link ID must be specified.
//
//    // Example sending a request using GetLinkAssociationsRequest.
//    req := client.GetLinkAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/GetLinkAssociations
func (c *Client) GetLinkAssociationsRequest(input *GetLinkAssociationsInput) GetLinkAssociationsRequest {
	op := &aws.Operation{
		Name:       opGetLinkAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/global-networks/{globalNetworkId}/link-associations",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetLinkAssociationsInput{}
	}

	req := c.newRequest(op, input, &GetLinkAssociationsOutput{})

	return GetLinkAssociationsRequest{Request: req, Input: input, Copy: c.GetLinkAssociationsRequest}
}

// GetLinkAssociationsRequest is the request type for the
// GetLinkAssociations API operation.
type GetLinkAssociationsRequest struct {
	*aws.Request
	Input *GetLinkAssociationsInput
	Copy  func(*GetLinkAssociationsInput) GetLinkAssociationsRequest
}

// Send marshals and sends the GetLinkAssociations API request.
func (r GetLinkAssociationsRequest) Send(ctx context.Context) (*GetLinkAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetLinkAssociationsResponse{
		GetLinkAssociationsOutput: r.Request.Data.(*GetLinkAssociationsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetLinkAssociationsRequestPaginator returns a paginator for GetLinkAssociations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetLinkAssociationsRequest(input)
//   p := networkmanager.NewGetLinkAssociationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetLinkAssociationsPaginator(req GetLinkAssociationsRequest) GetLinkAssociationsPaginator {
	return GetLinkAssociationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetLinkAssociationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetLinkAssociationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetLinkAssociationsPaginator struct {
	aws.Pager
}

func (p *GetLinkAssociationsPaginator) CurrentPage() *GetLinkAssociationsOutput {
	return p.Pager.CurrentPage().(*GetLinkAssociationsOutput)
}

// GetLinkAssociationsResponse is the response type for the
// GetLinkAssociations API operation.
type GetLinkAssociationsResponse struct {
	*GetLinkAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetLinkAssociations request.
func (r *GetLinkAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
