// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type RegisterTransitGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the transit gateway. For more information,
	// see Resources Defined by Amazon EC2 (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonec2.html#amazonec2-resources-for-iam-policies).
	//
	// TransitGatewayArn is a required field
	TransitGatewayArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterTransitGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterTransitGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterTransitGatewayInput"}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if s.TransitGatewayArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransitGatewayArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RegisterTransitGatewayInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TransitGatewayArn != nil {
		v := *s.TransitGatewayArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TransitGatewayArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type RegisterTransitGatewayOutput struct {
	_ struct{} `type:"structure"`

	// Information about the transit gateway registration.
	TransitGatewayRegistration *TransitGatewayRegistration `type:"structure"`
}

// String returns the string representation
func (s RegisterTransitGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RegisterTransitGatewayOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.TransitGatewayRegistration != nil {
		v := s.TransitGatewayRegistration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TransitGatewayRegistration", v, metadata)
	}
	return nil
}

const opRegisterTransitGateway = "RegisterTransitGateway"

// RegisterTransitGatewayRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Registers a transit gateway in your global network. The transit gateway can
// be in any AWS Region, but it must be owned by the same AWS account that owns
// the global network. You cannot register a transit gateway in more than one
// global network.
//
//    // Example sending a request using RegisterTransitGatewayRequest.
//    req := client.RegisterTransitGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/RegisterTransitGateway
func (c *Client) RegisterTransitGatewayRequest(input *RegisterTransitGatewayInput) RegisterTransitGatewayRequest {
	op := &aws.Operation{
		Name:       opRegisterTransitGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/global-networks/{globalNetworkId}/transit-gateway-registrations",
	}

	if input == nil {
		input = &RegisterTransitGatewayInput{}
	}

	req := c.newRequest(op, input, &RegisterTransitGatewayOutput{})

	return RegisterTransitGatewayRequest{Request: req, Input: input, Copy: c.RegisterTransitGatewayRequest}
}

// RegisterTransitGatewayRequest is the request type for the
// RegisterTransitGateway API operation.
type RegisterTransitGatewayRequest struct {
	*aws.Request
	Input *RegisterTransitGatewayInput
	Copy  func(*RegisterTransitGatewayInput) RegisterTransitGatewayRequest
}

// Send marshals and sends the RegisterTransitGateway API request.
func (r RegisterTransitGatewayRequest) Send(ctx context.Context) (*RegisterTransitGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterTransitGatewayResponse{
		RegisterTransitGatewayOutput: r.Request.Data.(*RegisterTransitGatewayOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterTransitGatewayResponse is the response type for the
// RegisterTransitGateway API operation.
type RegisterTransitGatewayResponse struct {
	*RegisterTransitGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterTransitGateway request.
func (r *RegisterTransitGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
