// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type AssignInstanceInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The layer ID, which must correspond to a custom layer. You cannot assign
	// a registered instance to a built-in layer.
	//
	// LayerIds is a required field
	LayerIds []string `type:"list" required:"true"`
}

// String returns the string representation
func (s AssignInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssignInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssignInstanceInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if s.LayerIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("LayerIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssignInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssignInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssignInstance = "AssignInstance"

// AssignInstanceRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Assign a registered instance to a layer.
//
//    * You can assign registered on-premises instances to any layer type.
//
//    * You can assign registered Amazon EC2 instances only to custom layers.
//
//    * You cannot use this action with instances that were created with AWS
//    OpsWorks Stacks.
//
// Required Permissions: To use this action, an AWS Identity and Access Management
// (IAM) user must have a Manage permissions level for the stack or an attached
// policy that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using AssignInstanceRequest.
//    req := client.AssignInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AssignInstance
func (c *Client) AssignInstanceRequest(input *AssignInstanceInput) AssignInstanceRequest {
	op := &aws.Operation{
		Name:       opAssignInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignInstanceInput{}
	}

	req := c.newRequest(op, input, &AssignInstanceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return AssignInstanceRequest{Request: req, Input: input, Copy: c.AssignInstanceRequest}
}

// AssignInstanceRequest is the request type for the
// AssignInstance API operation.
type AssignInstanceRequest struct {
	*aws.Request
	Input *AssignInstanceInput
	Copy  func(*AssignInstanceInput) AssignInstanceRequest
}

// Send marshals and sends the AssignInstance API request.
func (r AssignInstanceRequest) Send(ctx context.Context) (*AssignInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssignInstanceResponse{
		AssignInstanceOutput: r.Request.Data.(*AssignInstanceOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssignInstanceResponse is the response type for the
// AssignInstance API operation.
type AssignInstanceResponse struct {
	*AssignInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssignInstance request.
func (r *AssignInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
