// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateUserProfileInput struct {
	_ struct{} `type:"structure"`

	// Whether users can specify their own SSH public key through the My Settings
	// page. For more information, see Setting an IAM User's Public SSH Key (https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html).
	AllowSelfManagement *bool `type:"boolean"`

	// The user's IAM ARN; this can also be a federated user's ARN.
	//
	// IamUserArn is a required field
	IamUserArn *string `type:"string" required:"true"`

	// The user's public SSH key.
	SshPublicKey *string `type:"string"`

	// The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9],
	// '-', and '_'. If the specified name includes other punctuation marks, AWS
	// OpsWorks Stacks removes them. For example, my.name will be changed to myname.
	// If you do not specify an SSH user name, AWS OpsWorks Stacks generates one
	// from the IAM user name.
	SshUsername *string `type:"string"`
}

// String returns the string representation
func (s CreateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateUserProfileInput"}

	if s.IamUserArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("IamUserArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a CreateUserProfile request.
type CreateUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string"`
}

// String returns the string representation
func (s CreateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateUserProfile = "CreateUserProfile"

// CreateUserProfileRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Creates a new user profile.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information about user
// permissions, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using CreateUserProfileRequest.
//    req := client.CreateUserProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateUserProfile
func (c *Client) CreateUserProfileRequest(input *CreateUserProfileInput) CreateUserProfileRequest {
	op := &aws.Operation{
		Name:       opCreateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserProfileInput{}
	}

	req := c.newRequest(op, input, &CreateUserProfileOutput{})

	return CreateUserProfileRequest{Request: req, Input: input, Copy: c.CreateUserProfileRequest}
}

// CreateUserProfileRequest is the request type for the
// CreateUserProfile API operation.
type CreateUserProfileRequest struct {
	*aws.Request
	Input *CreateUserProfileInput
	Copy  func(*CreateUserProfileInput) CreateUserProfileRequest
}

// Send marshals and sends the CreateUserProfile API request.
func (r CreateUserProfileRequest) Send(ctx context.Context) (*CreateUserProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateUserProfileResponse{
		CreateUserProfileOutput: r.Request.Data.(*CreateUserProfileOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateUserProfileResponse is the response type for the
// CreateUserProfile API operation.
type CreateUserProfileResponse struct {
	*CreateUserProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateUserProfile request.
func (r *CreateUserProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
