// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteStackInput struct {
	_ struct{} `type:"structure"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteStackInput"}

	if s.StackId == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Deletes a specified stack. You must first delete all instances, layers, and
// apps or deregister registered instances. For more information, see Shut Down
// a Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-shutting.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DeleteStackRequest.
//    req := client.DeleteStackRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteStack
func (c *Client) DeleteStackRequest(input *DeleteStackInput) DeleteStackRequest {
	op := &aws.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	req := c.newRequest(op, input, &DeleteStackOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteStackRequest{Request: req, Input: input, Copy: c.DeleteStackRequest}
}

// DeleteStackRequest is the request type for the
// DeleteStack API operation.
type DeleteStackRequest struct {
	*aws.Request
	Input *DeleteStackInput
	Copy  func(*DeleteStackInput) DeleteStackRequest
}

// Send marshals and sends the DeleteStack API request.
func (r DeleteStackRequest) Send(ctx context.Context) (*DeleteStackResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteStackResponse{
		DeleteStackOutput: r.Request.Data.(*DeleteStackOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteStackResponse is the response type for the
// DeleteStack API operation.
type DeleteStackResponse struct {
	*DeleteStackOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteStack request.
func (r *DeleteStackResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
