// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAgentVersionsInput struct {
	_ struct{} `type:"structure"`

	// The configuration manager.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeAgentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the response to a DescribeAgentVersions request.
type DescribeAgentVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The agent versions for the specified stack or configuration manager. Note
	// that this value is the complete version number, not the abbreviated number
	// used by the console.
	AgentVersions []AgentVersion `type:"list"`
}

// String returns the string representation
func (s DescribeAgentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAgentVersions = "DescribeAgentVersions"

// DescribeAgentVersionsRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Describes the available AWS OpsWorks Stacks agent versions. You must specify
// a stack ID or a configuration manager. DescribeAgentVersions returns a list
// of available agent versions for the specified stack or configuration manager.
//
//    // Example sending a request using DescribeAgentVersionsRequest.
//    req := client.DescribeAgentVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeAgentVersions
func (c *Client) DescribeAgentVersionsRequest(input *DescribeAgentVersionsInput) DescribeAgentVersionsRequest {
	op := &aws.Operation{
		Name:       opDescribeAgentVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAgentVersionsInput{}
	}

	req := c.newRequest(op, input, &DescribeAgentVersionsOutput{})

	return DescribeAgentVersionsRequest{Request: req, Input: input, Copy: c.DescribeAgentVersionsRequest}
}

// DescribeAgentVersionsRequest is the request type for the
// DescribeAgentVersions API operation.
type DescribeAgentVersionsRequest struct {
	*aws.Request
	Input *DescribeAgentVersionsInput
	Copy  func(*DescribeAgentVersionsInput) DescribeAgentVersionsRequest
}

// Send marshals and sends the DescribeAgentVersions API request.
func (r DescribeAgentVersionsRequest) Send(ctx context.Context) (*DescribeAgentVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAgentVersionsResponse{
		DescribeAgentVersionsOutput: r.Request.Data.(*DescribeAgentVersionsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAgentVersionsResponse is the response type for the
// DescribeAgentVersions API operation.
type DescribeAgentVersionsResponse struct {
	*DescribeAgentVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAgentVersions request.
func (r *DescribeAgentVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
