// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// The app ID. If you include this parameter, the command returns a description
	// of the commands associated with the specified app.
	AppId *string `type:"string"`

	// An array of deployment IDs to be described. If you include this parameter,
	// the command returns a description of the specified deployments. Otherwise,
	// it returns a description of every deployment.
	DeploymentIds []string `type:"list"`

	// The stack ID. If you include this parameter, the command returns a description
	// of the commands associated with the specified stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the response to a DescribeDeployments request.
type DescribeDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Deployment objects that describe the deployments.
	Deployments []Deployment `type:"list"`
}

// String returns the string representation
func (s DescribeDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDeployments = "DescribeDeployments"

// DescribeDeploymentsRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Requests a description of a specified set of deployments.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DescribeDeploymentsRequest.
//    req := client.DescribeDeploymentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeDeployments
func (c *Client) DescribeDeploymentsRequest(input *DescribeDeploymentsInput) DescribeDeploymentsRequest {
	op := &aws.Operation{
		Name:       opDescribeDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeploymentsInput{}
	}

	req := c.newRequest(op, input, &DescribeDeploymentsOutput{})

	return DescribeDeploymentsRequest{Request: req, Input: input, Copy: c.DescribeDeploymentsRequest}
}

// DescribeDeploymentsRequest is the request type for the
// DescribeDeployments API operation.
type DescribeDeploymentsRequest struct {
	*aws.Request
	Input *DescribeDeploymentsInput
	Copy  func(*DescribeDeploymentsInput) DescribeDeploymentsRequest
}

// Send marshals and sends the DescribeDeployments API request.
func (r DescribeDeploymentsRequest) Send(ctx context.Context) (*DescribeDeploymentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDeploymentsResponse{
		DescribeDeploymentsOutput: r.Request.Data.(*DescribeDeploymentsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDeploymentsResponse is the response type for the
// DescribeDeployments API operation.
type DescribeDeploymentsResponse struct {
	*DescribeDeploymentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDeployments request.
func (r *DescribeDeploymentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
