// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeRaidArraysInput struct {
	_ struct{} `type:"structure"`

	// The instance ID. If you use this parameter, DescribeRaidArrays returns descriptions
	// of the RAID arrays associated with the specified instance.
	InstanceId *string `type:"string"`

	// An array of RAID array IDs. If you use this parameter, DescribeRaidArrays
	// returns descriptions of the specified arrays. Otherwise, it returns a description
	// of every array.
	RaidArrayIds []string `type:"list"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeRaidArraysInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the response to a DescribeRaidArrays request.
type DescribeRaidArraysOutput struct {
	_ struct{} `type:"structure"`

	// A RaidArrays object that describes the specified RAID arrays.
	RaidArrays []RaidArray `type:"list"`
}

// String returns the string representation
func (s DescribeRaidArraysOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeRaidArrays = "DescribeRaidArrays"

// DescribeRaidArraysRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Describe an instance's RAID arrays.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DescribeRaidArraysRequest.
//    req := client.DescribeRaidArraysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeRaidArrays
func (c *Client) DescribeRaidArraysRequest(input *DescribeRaidArraysInput) DescribeRaidArraysRequest {
	op := &aws.Operation{
		Name:       opDescribeRaidArrays,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRaidArraysInput{}
	}

	req := c.newRequest(op, input, &DescribeRaidArraysOutput{})

	return DescribeRaidArraysRequest{Request: req, Input: input, Copy: c.DescribeRaidArraysRequest}
}

// DescribeRaidArraysRequest is the request type for the
// DescribeRaidArrays API operation.
type DescribeRaidArraysRequest struct {
	*aws.Request
	Input *DescribeRaidArraysInput
	Copy  func(*DescribeRaidArraysInput) DescribeRaidArraysRequest
}

// Send marshals and sends the DescribeRaidArrays API request.
func (r DescribeRaidArraysRequest) Send(ctx context.Context) (*DescribeRaidArraysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRaidArraysResponse{
		DescribeRaidArraysOutput: r.Request.Data.(*DescribeRaidArraysOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeRaidArraysResponse is the response type for the
// DescribeRaidArrays API operation.
type DescribeRaidArraysResponse struct {
	*DescribeRaidArraysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRaidArrays request.
func (r *DescribeRaidArraysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
