// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GrantAccessInput struct {
	_ struct{} `type:"structure"`

	// The instance's AWS OpsWorks Stacks ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The length of time (in minutes) that the grant is valid. When the grant expires
	// at the end of this period, the user will no longer be able to use the credentials
	// to log in. If the user is logged in at the time, he or she automatically
	// will be logged out.
	ValidForInMinutes *int64 `min:"60" type:"integer"`
}

// String returns the string representation
func (s GrantAccessInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantAccessInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GrantAccessInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.ValidForInMinutes != nil && *s.ValidForInMinutes < 60 {
		invalidParams.Add(aws.NewErrParamMinValue("ValidForInMinutes", 60))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a GrantAccess request.
type GrantAccessOutput struct {
	_ struct{} `type:"structure"`

	// A TemporaryCredential object that contains the data needed to log in to the
	// instance by RDP clients, such as the Microsoft Remote Desktop Connection.
	TemporaryCredential *TemporaryCredential `type:"structure"`
}

// String returns the string representation
func (s GrantAccessOutput) String() string {
	return awsutil.Prettify(s)
}

const opGrantAccess = "GrantAccess"

// GrantAccessRequest returns a request value for making API operation for
// AWS OpsWorks.
//
//
// This action can be used only with Windows stacks.
//
// Grants RDP access to a Windows instance for a specified time period.
//
//    // Example sending a request using GrantAccessRequest.
//    req := client.GrantAccessRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/GrantAccess
func (c *Client) GrantAccessRequest(input *GrantAccessInput) GrantAccessRequest {
	op := &aws.Operation{
		Name:       opGrantAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GrantAccessInput{}
	}

	req := c.newRequest(op, input, &GrantAccessOutput{})

	return GrantAccessRequest{Request: req, Input: input, Copy: c.GrantAccessRequest}
}

// GrantAccessRequest is the request type for the
// GrantAccess API operation.
type GrantAccessRequest struct {
	*aws.Request
	Input *GrantAccessInput
	Copy  func(*GrantAccessInput) GrantAccessRequest
}

// Send marshals and sends the GrantAccess API request.
func (r GrantAccessRequest) Send(ctx context.Context) (*GrantAccessResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GrantAccessResponse{
		GrantAccessOutput: r.Request.Data.(*GrantAccessOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GrantAccessResponse is the response type for the
// GrantAccess API operation.
type GrantAccessResponse struct {
	*GrantAccessOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GrantAccess request.
func (r *GrantAccessResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
