// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type StartStackInput struct {
	_ struct{} `type:"structure"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartStackInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartStackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartStackInput"}

	if s.StackId == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartStackOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartStack = "StartStack"

// StartStackRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Starts a stack's instances.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using StartStackRequest.
//    req := client.StartStackRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StartStack
func (c *Client) StartStackRequest(input *StartStackInput) StartStackRequest {
	op := &aws.Operation{
		Name:       opStartStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartStackInput{}
	}

	req := c.newRequest(op, input, &StartStackOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return StartStackRequest{Request: req, Input: input, Copy: c.StartStackRequest}
}

// StartStackRequest is the request type for the
// StartStack API operation.
type StartStackRequest struct {
	*aws.Request
	Input *StartStackInput
	Copy  func(*StartStackInput) StartStackRequest
}

// Send marshals and sends the StartStack API request.
func (r StartStackRequest) Send(ctx context.Context) (*StartStackResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartStackResponse{
		StartStackOutput: r.Request.Data.(*StartStackOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartStackResponse is the response type for the
// StartStack API operation.
type StartStackResponse struct {
	*StartStackOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartStack request.
func (r *StartStackResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
