// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworkscm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateServerEngineAttributesInput struct {
	_ struct{} `type:"structure"`

	// The name of the engine attribute to update.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The value to set for the attribute.
	AttributeValue *string `type:"string"`

	// The name of the server to update.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerEngineAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServerEngineAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateServerEngineAttributesInput"}

	if s.AttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributeName", 1))
	}

	if s.ServerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateServerEngineAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Contains the response to an UpdateServerEngineAttributes request.
	Server *Server `type:"structure"`
}

// String returns the string representation
func (s UpdateServerEngineAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateServerEngineAttributes = "UpdateServerEngineAttributes"

// UpdateServerEngineAttributesRequest returns a request value for making API operation for
// AWS OpsWorks CM.
//
// Updates engine-specific attributes on a specified server. The server enters
// the MODIFYING state when this operation is in progress. Only one update can
// occur at a time. You can use this command to reset a Chef server's public
// key (CHEF_PIVOTAL_KEY) or a Puppet server's admin password (PUPPET_ADMIN_PASSWORD).
//
// This operation is asynchronous.
//
// This operation can only be called for servers in HEALTHY or UNHEALTHY states.
// Otherwise, an InvalidStateException is raised. A ResourceNotFoundException
// is thrown when the server does not exist. A ValidationException is raised
// when parameters of the request are not valid.
//
//    // Example sending a request using UpdateServerEngineAttributesRequest.
//    req := client.UpdateServerEngineAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/UpdateServerEngineAttributes
func (c *Client) UpdateServerEngineAttributesRequest(input *UpdateServerEngineAttributesInput) UpdateServerEngineAttributesRequest {
	op := &aws.Operation{
		Name:       opUpdateServerEngineAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServerEngineAttributesInput{}
	}

	req := c.newRequest(op, input, &UpdateServerEngineAttributesOutput{})

	return UpdateServerEngineAttributesRequest{Request: req, Input: input, Copy: c.UpdateServerEngineAttributesRequest}
}

// UpdateServerEngineAttributesRequest is the request type for the
// UpdateServerEngineAttributes API operation.
type UpdateServerEngineAttributesRequest struct {
	*aws.Request
	Input *UpdateServerEngineAttributesInput
	Copy  func(*UpdateServerEngineAttributesInput) UpdateServerEngineAttributesRequest
}

// Send marshals and sends the UpdateServerEngineAttributes API request.
func (r UpdateServerEngineAttributesRequest) Send(ctx context.Context) (*UpdateServerEngineAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateServerEngineAttributesResponse{
		UpdateServerEngineAttributesOutput: r.Request.Data.(*UpdateServerEngineAttributesOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateServerEngineAttributesResponse is the response type for the
// UpdateServerEngineAttributes API operation.
type UpdateServerEngineAttributesResponse struct {
	*UpdateServerEngineAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateServerEngineAttributes request.
func (r *UpdateServerEngineAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
