// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeregisterDelegatedAdministratorInput struct {
	_ struct{} `type:"structure"`

	// The account ID number of the member account in the organization that you
	// want to deregister as a delegated administrator.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The service principal name of an AWS service for which the account is a delegated
	// administrator.
	//
	// Delegated administrator privileges are revoked for only the specified AWS
	// service from the member account. If the specified service is the only service
	// for which the member account is a delegated administrator, the operation
	// also revokes Organizations read action permissions.
	//
	// ServicePrincipal is a required field
	ServicePrincipal *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterDelegatedAdministratorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterDelegatedAdministratorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterDelegatedAdministratorInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.ServicePrincipal == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServicePrincipal"))
	}
	if s.ServicePrincipal != nil && len(*s.ServicePrincipal) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServicePrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterDelegatedAdministratorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterDelegatedAdministratorOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterDelegatedAdministrator = "DeregisterDelegatedAdministrator"

// DeregisterDelegatedAdministratorRequest returns a request value for making API operation for
// AWS Organizations.
//
// Removes the specified member AWS account as a delegated administrator for
// the specified AWS service.
//
// You can run this action only for AWS services that support this feature.
// For a current list of services that support it, see the column Supports Delegated
// Administrator in the table at AWS Services that you can use with AWS Organizations
// (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrated-services-list.html)
// in the AWS Organizations User Guide.
//
// This operation can be called only from the organization's master account.
//
//    // Example sending a request using DeregisterDelegatedAdministratorRequest.
//    req := client.DeregisterDelegatedAdministratorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeregisterDelegatedAdministrator
func (c *Client) DeregisterDelegatedAdministratorRequest(input *DeregisterDelegatedAdministratorInput) DeregisterDelegatedAdministratorRequest {
	op := &aws.Operation{
		Name:       opDeregisterDelegatedAdministrator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterDelegatedAdministratorInput{}
	}

	req := c.newRequest(op, input, &DeregisterDelegatedAdministratorOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeregisterDelegatedAdministratorRequest{Request: req, Input: input, Copy: c.DeregisterDelegatedAdministratorRequest}
}

// DeregisterDelegatedAdministratorRequest is the request type for the
// DeregisterDelegatedAdministrator API operation.
type DeregisterDelegatedAdministratorRequest struct {
	*aws.Request
	Input *DeregisterDelegatedAdministratorInput
	Copy  func(*DeregisterDelegatedAdministratorInput) DeregisterDelegatedAdministratorRequest
}

// Send marshals and sends the DeregisterDelegatedAdministrator API request.
func (r DeregisterDelegatedAdministratorRequest) Send(ctx context.Context) (*DeregisterDelegatedAdministratorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterDelegatedAdministratorResponse{
		DeregisterDelegatedAdministratorOutput: r.Request.Data.(*DeregisterDelegatedAdministratorOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterDelegatedAdministratorResponse is the response type for the
// DeregisterDelegatedAdministrator API operation.
type DeregisterDelegatedAdministratorResponse struct {
	*DeregisterDelegatedAdministratorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterDelegatedAdministrator request.
func (r *DeregisterDelegatedAdministratorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
