// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeCreateAccountStatusInput struct {
	_ struct{} `type:"structure"`

	// Specifies the operationId that uniquely identifies the request. You can get
	// the ID from the response to an earlier CreateAccount request, or from the
	// ListCreateAccountStatus operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a create account
	// request ID string requires "car-" followed by from 8 to 32 lowercase letters
	// or digits.
	//
	// CreateAccountRequestId is a required field
	CreateAccountRequestId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCreateAccountStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCreateAccountStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeCreateAccountStatusInput"}

	if s.CreateAccountRequestId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CreateAccountRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeCreateAccountStatusOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the current status of an account creation request.
	CreateAccountStatus *CreateAccountStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeCreateAccountStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeCreateAccountStatus = "DescribeCreateAccountStatus"

// DescribeCreateAccountStatusRequest returns a request value for making API operation for
// AWS Organizations.
//
// Retrieves the current status of an asynchronous request to create an account.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
//    // Example sending a request using DescribeCreateAccountStatusRequest.
//    req := client.DescribeCreateAccountStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeCreateAccountStatus
func (c *Client) DescribeCreateAccountStatusRequest(input *DescribeCreateAccountStatusInput) DescribeCreateAccountStatusRequest {
	op := &aws.Operation{
		Name:       opDescribeCreateAccountStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCreateAccountStatusInput{}
	}

	req := c.newRequest(op, input, &DescribeCreateAccountStatusOutput{})

	return DescribeCreateAccountStatusRequest{Request: req, Input: input, Copy: c.DescribeCreateAccountStatusRequest}
}

// DescribeCreateAccountStatusRequest is the request type for the
// DescribeCreateAccountStatus API operation.
type DescribeCreateAccountStatusRequest struct {
	*aws.Request
	Input *DescribeCreateAccountStatusInput
	Copy  func(*DescribeCreateAccountStatusInput) DescribeCreateAccountStatusRequest
}

// Send marshals and sends the DescribeCreateAccountStatus API request.
func (r DescribeCreateAccountStatusRequest) Send(ctx context.Context) (*DescribeCreateAccountStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCreateAccountStatusResponse{
		DescribeCreateAccountStatusOutput: r.Request.Data.(*DescribeCreateAccountStatusOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeCreateAccountStatusResponse is the response type for the
// DescribeCreateAccountStatus API operation.
type DescribeCreateAccountStatusResponse struct {
	*DescribeCreateAccountStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCreateAccountStatus request.
func (r *DescribeCreateAccountStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
