// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListDelegatedServicesForAccountInput struct {
	_ struct{} `type:"structure"`

	// The account ID number of a delegated administrator account in the organization.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value of the previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDelegatedServicesForAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDelegatedServicesForAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDelegatedServicesForAccountInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListDelegatedServicesForAccountOutput struct {
	_ struct{} `type:"structure"`

	// The services for which the account is a delegated administrator.
	DelegatedServices []DelegatedService `type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDelegatedServicesForAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDelegatedServicesForAccount = "ListDelegatedServicesForAccount"

// ListDelegatedServicesForAccountRequest returns a request value for making API operation for
// AWS Organizations.
//
// List the AWS services for which the specified account is a delegated administrator.
//
// This operation can be called only from the organization's master account
// or by a member account that is a delegated administrator for an AWS service.
//
//    // Example sending a request using ListDelegatedServicesForAccountRequest.
//    req := client.ListDelegatedServicesForAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListDelegatedServicesForAccount
func (c *Client) ListDelegatedServicesForAccountRequest(input *ListDelegatedServicesForAccountInput) ListDelegatedServicesForAccountRequest {
	op := &aws.Operation{
		Name:       opListDelegatedServicesForAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDelegatedServicesForAccountInput{}
	}

	req := c.newRequest(op, input, &ListDelegatedServicesForAccountOutput{})

	return ListDelegatedServicesForAccountRequest{Request: req, Input: input, Copy: c.ListDelegatedServicesForAccountRequest}
}

// ListDelegatedServicesForAccountRequest is the request type for the
// ListDelegatedServicesForAccount API operation.
type ListDelegatedServicesForAccountRequest struct {
	*aws.Request
	Input *ListDelegatedServicesForAccountInput
	Copy  func(*ListDelegatedServicesForAccountInput) ListDelegatedServicesForAccountRequest
}

// Send marshals and sends the ListDelegatedServicesForAccount API request.
func (r ListDelegatedServicesForAccountRequest) Send(ctx context.Context) (*ListDelegatedServicesForAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDelegatedServicesForAccountResponse{
		ListDelegatedServicesForAccountOutput: r.Request.Data.(*ListDelegatedServicesForAccountOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDelegatedServicesForAccountRequestPaginator returns a paginator for ListDelegatedServicesForAccount.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDelegatedServicesForAccountRequest(input)
//   p := organizations.NewListDelegatedServicesForAccountRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDelegatedServicesForAccountPaginator(req ListDelegatedServicesForAccountRequest) ListDelegatedServicesForAccountPaginator {
	return ListDelegatedServicesForAccountPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDelegatedServicesForAccountInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDelegatedServicesForAccountPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDelegatedServicesForAccountPaginator struct {
	aws.Pager
}

func (p *ListDelegatedServicesForAccountPaginator) CurrentPage() *ListDelegatedServicesForAccountOutput {
	return p.Pager.CurrentPage().(*ListDelegatedServicesForAccountOutput)
}

// ListDelegatedServicesForAccountResponse is the response type for the
// ListDelegatedServicesForAccount API operation.
type ListDelegatedServicesForAccountResponse struct {
	*ListDelegatedServicesForAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDelegatedServicesForAccount request.
func (r *ListDelegatedServicesForAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
