// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package outposts

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteOutpostInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Outpost.
	//
	// OutpostId is a required field
	OutpostId *string `location:"uri" locationName:"OutpostId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOutpostInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOutpostInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteOutpostInput"}

	if s.OutpostId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutpostId"))
	}
	if s.OutpostId != nil && len(*s.OutpostId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OutpostId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteOutpostInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.OutpostId != nil {
		v := *s.OutpostId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "OutpostId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteOutpostOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOutpostOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteOutpostOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteOutpost = "DeleteOutpost"

// DeleteOutpostRequest returns a request value for making API operation for
// AWS Outposts.
//
// Deletes the Outpost.
//
//    // Example sending a request using DeleteOutpostRequest.
//    req := client.DeleteOutpostRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteOutpost
func (c *Client) DeleteOutpostRequest(input *DeleteOutpostInput) DeleteOutpostRequest {
	op := &aws.Operation{
		Name:       opDeleteOutpost,
		HTTPMethod: "DELETE",
		HTTPPath:   "/outposts/{OutpostId}",
	}

	if input == nil {
		input = &DeleteOutpostInput{}
	}

	req := c.newRequest(op, input, &DeleteOutpostOutput{})

	return DeleteOutpostRequest{Request: req, Input: input, Copy: c.DeleteOutpostRequest}
}

// DeleteOutpostRequest is the request type for the
// DeleteOutpost API operation.
type DeleteOutpostRequest struct {
	*aws.Request
	Input *DeleteOutpostInput
	Copy  func(*DeleteOutpostInput) DeleteOutpostRequest
}

// Send marshals and sends the DeleteOutpost API request.
func (r DeleteOutpostRequest) Send(ctx context.Context) (*DeleteOutpostResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteOutpostResponse{
		DeleteOutpostOutput: r.Request.Data.(*DeleteOutpostOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteOutpostResponse is the response type for the
// DeleteOutpost API operation.
type DeleteOutpostResponse struct {
	*DeleteOutpostOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteOutpost request.
func (r *DeleteOutpostResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
