// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDatasetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group to add the dataset to.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`

	// The type of dataset.
	//
	// One of the following (case insensitive) values:
	//
	//    * Interactions
	//
	//    * Items
	//
	//    * Users
	//
	// DatasetType is a required field
	DatasetType *string `locationName:"datasetType" type:"string" required:"true"`

	// The name for the dataset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN of the schema to associate with the dataset. The schema defines the
	// dataset fields.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDatasetInput"}

	if s.DatasetGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetGroupArn"))
	}

	if s.DatasetType == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetType"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.SchemaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset.
	DatasetArn *string `locationName:"datasetArn" type:"string"`
}

// String returns the string representation
func (s CreateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDataset = "CreateDataset"

// CreateDatasetRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Creates an empty dataset and adds it to the specified dataset group. Use
// CreateDatasetImportJob to import your training data to a dataset.
//
// There are three types of datasets:
//
//    * Interactions
//
//    * Items
//
//    * Users
//
// Each dataset type has an associated schema with required field types. Only
// the Interactions dataset is required in order to train a model (also referred
// to as creating a solution).
//
// A dataset can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//    * DELETE PENDING > DELETE IN_PROGRESS
//
// To get the status of the dataset, call DescribeDataset.
//
// Related APIs
//
//    * CreateDatasetGroup
//
//    * ListDatasets
//
//    * DescribeDataset
//
//    * DeleteDataset
//
//    // Example sending a request using CreateDatasetRequest.
//    req := client.CreateDatasetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDataset
func (c *Client) CreateDatasetRequest(input *CreateDatasetInput) CreateDatasetRequest {
	op := &aws.Operation{
		Name:       opCreateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetInput{}
	}

	req := c.newRequest(op, input, &CreateDatasetOutput{})

	return CreateDatasetRequest{Request: req, Input: input, Copy: c.CreateDatasetRequest}
}

// CreateDatasetRequest is the request type for the
// CreateDataset API operation.
type CreateDatasetRequest struct {
	*aws.Request
	Input *CreateDatasetInput
	Copy  func(*CreateDatasetInput) CreateDatasetRequest
}

// Send marshals and sends the CreateDataset API request.
func (r CreateDatasetRequest) Send(ctx context.Context) (*CreateDatasetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDatasetResponse{
		CreateDatasetOutput: r.Request.Data.(*CreateDatasetOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDatasetResponse is the response type for the
// CreateDataset API operation.
type CreateDatasetResponse struct {
	*CreateDatasetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDataset request.
func (r *CreateDatasetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
