// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateFilterInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset group that the filter will belong to.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `locationName:"datasetGroupArn" type:"string" required:"true"`

	// The filter expression that designates the interaction types that the filter
	// will filter out. A filter expression must follow the following format:
	//
	// EXCLUDE itemId WHERE INTERACTIONS.event_type in ("EVENT_TYPE")
	//
	// Where "EVENT_TYPE" is the type of event to filter out. To filter out all
	// items with any interactions history, set "*" as the EVENT_TYPE. For more
	// information, see Using Filters with Amazon Personalize.
	//
	// FilterExpression is a required field
	FilterExpression *string `locationName:"filterExpression" min:"1" type:"string" required:"true" sensitive:"true"`

	// The name of the filter to create.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFilterInput"}

	if s.DatasetGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetGroupArn"))
	}

	if s.FilterExpression == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterExpression"))
	}
	if s.FilterExpression != nil && len(*s.FilterExpression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FilterExpression", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateFilterOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new filter.
	FilterArn *string `locationName:"filterArn" type:"string"`
}

// String returns the string representation
func (s CreateFilterOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateFilter = "CreateFilter"

// CreateFilterRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Creates a recommendation filter. For more information, see Using Filters
// with Amazon Personalize.
//
//    // Example sending a request using CreateFilterRequest.
//    req := client.CreateFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateFilter
func (c *Client) CreateFilterRequest(input *CreateFilterInput) CreateFilterRequest {
	op := &aws.Operation{
		Name:       opCreateFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFilterInput{}
	}

	req := c.newRequest(op, input, &CreateFilterOutput{})

	return CreateFilterRequest{Request: req, Input: input, Copy: c.CreateFilterRequest}
}

// CreateFilterRequest is the request type for the
// CreateFilter API operation.
type CreateFilterRequest struct {
	*aws.Request
	Input *CreateFilterInput
	Copy  func(*CreateFilterInput) CreateFilterRequest
}

// Send marshals and sends the CreateFilter API request.
func (r CreateFilterRequest) Send(ctx context.Context) (*CreateFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateFilterResponse{
		CreateFilterOutput: r.Request.Data.(*CreateFilterOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateFilterResponse is the response type for the
// CreateFilter API operation.
type CreateFilterResponse struct {
	*CreateFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateFilter request.
func (r *CreateFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
