// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteFilterInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the filter to delete.
	//
	// FilterArn is a required field
	FilterArn *string `locationName:"filterArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFilterInput"}

	if s.FilterArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFilterOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteFilter = "DeleteFilter"

// DeleteFilterRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Deletes a filter.
//
//    // Example sending a request using DeleteFilterRequest.
//    req := client.DeleteFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteFilter
func (c *Client) DeleteFilterRequest(input *DeleteFilterInput) DeleteFilterRequest {
	op := &aws.Operation{
		Name:       opDeleteFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFilterInput{}
	}

	req := c.newRequest(op, input, &DeleteFilterOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteFilterRequest{Request: req, Input: input, Copy: c.DeleteFilterRequest}
}

// DeleteFilterRequest is the request type for the
// DeleteFilter API operation.
type DeleteFilterRequest struct {
	*aws.Request
	Input *DeleteFilterInput
	Copy  func(*DeleteFilterInput) DeleteFilterRequest
}

// Send marshals and sends the DeleteFilter API request.
func (r DeleteFilterRequest) Send(ctx context.Context) (*DeleteFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFilterResponse{
		DeleteFilterOutput: r.Request.Data.(*DeleteFilterOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFilterResponse is the response type for the
// DeleteFilter API operation.
type DeleteFilterResponse struct {
	*DeleteFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFilter request.
func (r *DeleteFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
